/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeBisectedHalf;
import com.degoos.wetsponge.enums.block.EnumBlockTypeDoorHinge;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeDoor;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;

public class Spigot13BlockTypeDoor
extends Spigot13BlockTypeDirectional
implements WSBlockTypeDoor {
    private EnumBlockTypeDoorHinge hinge;
    private EnumBlockTypeBisectedHalf half;
    private boolean open;
    private boolean powered;

    public Spigot13BlockTypeDoor(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockTypeDoorHinge hinge, EnumBlockTypeBisectedHalf half, boolean open, boolean powered) {
        super(numericalId, oldStringId, newStringId, maxStackSize, facing, faces);
        Validate.notNull((Object)hinge, "Hinge cannot be null!");
        Validate.notNull((Object)half, "Half cannot be null!");
        this.hinge = hinge;
        this.half = half;
        this.open = open;
        this.powered = powered;
    }

    @Override
    public EnumBlockTypeDoorHinge getHinge() {
        return this.hinge;
    }

    @Override
    public void setHinge(EnumBlockTypeDoorHinge hinge) {
        Validate.notNull((Object)hinge, "Hinge cannot be null!");
        this.hinge = hinge;
    }

    @Override
    public EnumBlockTypeBisectedHalf getHalf() {
        return this.half;
    }

    @Override
    public void setHalf(EnumBlockTypeBisectedHalf half) {
        Validate.notNull((Object)half, "Half cannot be null!");
        this.half = half;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public Spigot13BlockTypeDoor clone() {
        return new Spigot13BlockTypeDoor(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.getFacing(), this.getFaces(), this.hinge, this.half, this.open, this.powered);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Door) {
            ((Door)blockData).setPowered(this.powered);
            ((Door)blockData).setOpen(this.open);
            ((Door)blockData).setHinge(Door.Hinge.valueOf((String)this.hinge.name()));
            ((Door)blockData).setHalf(Bisected.Half.valueOf((String)this.half.name()));
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeDirectional readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Door) {
            this.half = EnumBlockTypeBisectedHalf.valueOf(((Door)blockData).getHalf().name());
            this.hinge = EnumBlockTypeDoorHinge.valueOf(((Door)blockData).getHalf().name());
            this.open = ((Door)blockData).isOpen();
            this.powered = ((Door)blockData).isPowered();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeDoor that = (Spigot13BlockTypeDoor)o;
        return this.open == that.open && this.powered == that.powered && this.hinge == that.hinge && this.half == that.half;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.hinge, this.half, this.open, this.powered});
    }
}

