/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeCocoa;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Cocoa;

public class Spigot13BlockTypeCocoa
extends Spigot13BlockTypeDirectional
implements WSBlockTypeCocoa {
    private int age;
    private int maximumAge;

    public Spigot13BlockTypeCocoa(EnumBlockFace facing, Set<EnumBlockFace> faces, int age, int maximumAge) {
        super(127, "minecraft:cocoa", "minecraft:cocoa", 64, facing, faces);
        this.age = age;
        this.maximumAge = maximumAge;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int age) {
        this.age = Math.min(this.maximumAge, Math.max(0, age));
    }

    @Override
    public int getMaximumAge() {
        return this.maximumAge;
    }

    @Override
    public Spigot13BlockTypeCocoa clone() {
        return new Spigot13BlockTypeCocoa(this.getFacing(), this.getFaces(), this.age, this.maximumAge);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Cocoa) {
            ((Cocoa)blockData).setAge(this.age);
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeCocoa readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Cocoa) {
            this.age = ((Cocoa)blockData).getAge();
            this.maximumAge = ((Cocoa)blockData).getMaximumAge();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeCocoa that = (Spigot13BlockTypeCocoa)o;
        return this.age == that.age && this.maximumAge == that.maximumAge;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.age, this.maximumAge);
    }
}

