/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeCake;
import java.util.Objects;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Cake;

public class Spigot13BlockTypeCake
extends Spigot13BlockType
implements WSBlockTypeCake {
    private int bites;
    private int maximumBites;

    public Spigot13BlockTypeCake(int bites, int maximumBites) {
        super(92, "minecraft:cake", "minecraft:cake", 64);
        this.bites = bites;
        this.maximumBites = maximumBites;
    }

    @Override
    public int getBites() {
        return this.bites;
    }

    @Override
    public void setBites(int bites) {
        this.bites = Math.min(this.maximumBites, Math.max(0, bites));
    }

    @Override
    public int getMaximumBites() {
        return this.maximumBites;
    }

    @Override
    public Spigot13BlockTypeCake clone() {
        return new Spigot13BlockTypeCake(this.bites, this.maximumBites);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Cake) {
            ((Cake)blockData).setBites(this.bites);
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeCake readBlockData(BlockData blockData) {
        if (blockData instanceof Cake) {
            this.bites = ((Cake)blockData).getBites();
            this.maximumBites = ((Cake)blockData).getMaximumBites();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeCake that = (Spigot13BlockTypeCake)o;
        return this.bites == that.bites && this.maximumBites == that.maximumBites;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bites, this.maximumBites);
    }
}

