/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeBrewingStand;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.BrewingStand;

public class Spigot13BlockTypeBrewingStand
extends Spigot13BlockType
implements WSBlockTypeBrewingStand {
    private Set<Integer> bottles;
    private int maximumBottles;

    public Spigot13BlockTypeBrewingStand(Set<Integer> bottles, int maximumBottles) {
        super(117, "minecraft:brewing_stand", "minecraft:brewing_stand", 64);
        this.bottles = bottles == null ? new HashSet() : bottles;
        this.maximumBottles = maximumBottles;
    }

    @Override
    public boolean hasBottle(int index) {
        return this.bottles.contains(index);
    }

    @Override
    public void setBottle(int index, boolean bottle) {
        if (bottle) {
            this.bottles.add(index);
        } else {
            this.bottles.remove(index);
        }
    }

    @Override
    public Set<Integer> getBottles() {
        return new HashSet<Integer>(this.bottles);
    }

    @Override
    public int getMaximumBottles() {
        return this.maximumBottles;
    }

    @Override
    public Spigot13BlockTypeBrewingStand clone() {
        return new Spigot13BlockTypeBrewingStand(new HashSet<Integer>(this.bottles), this.maximumBottles);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof BrewingStand) {
            ((BrewingStand)blockData).getBottles().forEach(target -> ((BrewingStand)blockData).setBottle(target.intValue(), false));
            this.bottles.forEach(target -> ((BrewingStand)blockData).setBottle(target.intValue(), true));
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeBrewingStand readBlockData(BlockData blockData) {
        if (blockData instanceof BrewingStand) {
            this.bottles = ((BrewingStand)blockData).getBottles();
            this.maximumBottles = ((BrewingStand)blockData).getMaximumBottles();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeBrewingStand that = (Spigot13BlockTypeBrewingStand)o;
        return this.maximumBottles == that.maximumBottles && Objects.equals(this.bottles, that.bottles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bottles, this.maximumBottles);
    }
}

