/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumBlockTypeRailShape;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeRail;
import com.degoos.wetsponge.util.Validate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.RailDirection;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeRail
extends SpongeBlockType
implements WSBlockTypeRail {
    private EnumBlockTypeRailShape shape;
    private Set<EnumBlockTypeRailShape> allowedShapes;

    public SpongeBlockTypeRail(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockTypeRailShape shape, Set<EnumBlockTypeRailShape> allowedShapes) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        Validate.notNull((Object)shape, "Shape cannot be null!");
        this.shape = shape;
        this.allowedShapes = allowedShapes;
    }

    @Override
    public EnumBlockTypeRailShape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(EnumBlockTypeRailShape shape) {
        Validate.notNull((Object)shape, "Shape cannot be null!");
        this.shape = shape;
    }

    @Override
    public Set<EnumBlockTypeRailShape> allowedShapes() {
        return new HashSet<EnumBlockTypeRailShape>(this.allowedShapes);
    }

    @Override
    public SpongeBlockTypeRail clone() {
        return new SpongeBlockTypeRail(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.shape, new HashSet<EnumBlockTypeRailShape>(this.allowedShapes));
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        return super.writeItemStack(itemStack);
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.RAIL_DIRECTION, Sponge.getRegistry().getType(RailDirection.class, this.shape.name()).orElseThrow(NullPointerException::new)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeRail readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.shape = valueContainer.get(Keys.RAIL_DIRECTION).map(target -> EnumBlockTypeRailShape.valueOf(target.getName())).orElse(EnumBlockTypeRailShape.NORTH_SOUTH);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeRail that = (SpongeBlockTypeRail)o;
        return this.shape == that.shape && Objects.equals(this.allowedShapes, that.allowedShapes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.shape, this.allowedShapes});
    }
}

