/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypePowerable;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypePowerable
extends SpongeBlockType
implements WSBlockTypePowerable {
    private boolean powered;

    public SpongeBlockTypePowerable(int numericalId, String oldStringId, String newStringId, int maxStackSize, boolean powered) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.powered = powered;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public SpongeBlockTypePowerable clone() {
        return new SpongeBlockTypePowerable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.powered);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.POWERED, (Object)this.powered);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.POWERED, (Object)this.powered).orElse(blockState);
    }

    @Override
    public SpongeBlockTypePowerable readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.powered = valueContainer.get(Keys.POWERED).orElse(false);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypePowerable that = (SpongeBlockTypePowerable)o;
        return this.powered == that.powered;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.powered);
    }
}

