/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeMultipleFacing;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.Direction;

public class SpongeBlockTypeMultipleFacing
extends SpongeBlockType
implements WSBlockTypeMultipleFacing {
    private Set<EnumBlockFace> faces;
    private Set<EnumBlockFace> allowedFaces;

    public SpongeBlockTypeMultipleFacing(int numericalId, String oldStringId, String newStringId, int maxStackSize, Set<EnumBlockFace> faces, Set<EnumBlockFace> allowedFaces) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.faces = faces;
        this.allowedFaces = allowedFaces;
    }

    @Override
    public boolean hasFace(EnumBlockFace face) {
        return this.faces.contains((Object)face);
    }

    @Override
    public void setFace(EnumBlockFace face, boolean enabled) {
        if (enabled) {
            this.faces.add(face);
        } else {
            this.faces.remove((Object)face);
        }
    }

    @Override
    public Set<EnumBlockFace> getFaces() {
        return new HashSet<EnumBlockFace>(this.faces);
    }

    @Override
    public Set<EnumBlockFace> getAllowedFaces() {
        return new HashSet<EnumBlockFace>(this.allowedFaces);
    }

    @Override
    public SpongeBlockTypeMultipleFacing clone() {
        return new SpongeBlockTypeMultipleFacing(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), new HashSet<EnumBlockFace>(this.faces), new HashSet<EnumBlockFace>(this.allowedFaces));
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.CONNECTED_DIRECTIONS, this.faces.stream().map(target -> Direction.valueOf((String)target.getSpongeName())).collect(Collectors.toSet()));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.CONNECTED_DIRECTIONS, this.faces.stream().map(target -> Direction.valueOf((String)target.getSpongeName())).collect(Collectors.toSet())).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeMultipleFacing readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.faces = ((Set)valueContainer.get(Keys.CONNECTED_DIRECTIONS).orElse(new HashSet())).stream().map(target -> EnumBlockFace.getBySpongeName(target.name()).orElseThrow(NullPointerException::new)).collect(Collectors.toSet());
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeMultipleFacing that = (SpongeBlockTypeMultipleFacing)o;
        return Objects.equals(this.faces, that.faces) && Objects.equals(this.allowedFaces, that.allowedFaces);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.faces, this.allowedFaces);
    }
}

