/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeLevelled;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeLevelled
extends SpongeBlockType
implements WSBlockTypeLevelled {
    private int level;
    private int maximumLevel;

    public SpongeBlockTypeLevelled(int numericalId, String oldStringId, String newStringId, int maxStackSize, int level, int maximumLevel) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.level = level;
        this.maximumLevel = maximumLevel;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = Math.min(this.maximumLevel, Math.max(0, level));
    }

    @Override
    public int getMaximumLevel() {
        return this.maximumLevel;
    }

    @Override
    public SpongeBlockTypeLevelled clone() {
        return new SpongeBlockTypeLevelled(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.level, this.maximumLevel);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.FLUID_LEVEL, (Object)this.level);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.FLUID_LEVEL, (Object)this.level).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeLevelled readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.level = valueContainer.get(Keys.FLUID_LEVEL).orElse(0);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeLevelled that = (SpongeBlockTypeLevelled)o;
        return this.level == that.level && this.maximumLevel == that.maximumLevel;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.level, this.maximumLevel);
    }
}

