/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeAgeable;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeAgeable
extends SpongeBlockType
implements WSBlockTypeAgeable {
    private int age;
    private int maximumAge;

    public SpongeBlockTypeAgeable(int numericalId, String oldStringId, String newStringId, int maxStackSize, int age, int maximumAge) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.age = age;
        this.maximumAge = maximumAge;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int age) {
        this.age = Math.min(this.maximumAge, Math.max(0, age));
    }

    @Override
    public int getMaximumAge() {
        return this.maximumAge;
    }

    @Override
    public SpongeBlockTypeAgeable clone() {
        return new SpongeBlockTypeAgeable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.age, this.maximumAge);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.GROWTH_STAGE, (Object)this.age);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.GROWTH_STAGE, (Object)this.age).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeAgeable readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.age = valueContainer.get(Keys.GROWTH_STAGE).orElse(0);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeAgeable that = (SpongeBlockTypeAgeable)o;
        return this.age == that.age && this.maximumAge == that.maximumAge;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.age, this.maximumAge);
    }
}

