/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.material.SpongeMaterial;
import com.degoos.wetsponge.material.block.WSBlockType;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockType
implements SpongeMaterial,
WSBlockType {
    private int numericalId;
    private String oldStringId;
    private String newStringId;
    private int maxStackSize;

    public SpongeBlockType(int numericalId, String oldStringId, String newStringId, int maxStackSize) {
        this.numericalId = numericalId < 0 ? -1 : numericalId;
        this.oldStringId = oldStringId == null || oldStringId.equals("") ? null : oldStringId;
        this.newStringId = newStringId;
        this.maxStackSize = Math.max(1, maxStackSize);
    }

    @Override
    public SpongeBlockType clone() {
        return new SpongeBlockType(this.numericalId, this.oldStringId, this.newStringId, this.maxStackSize);
    }

    @Override
    public int getNumericalId() {
        return this.numericalId;
    }

    @Override
    public String getStringId() {
        return WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13) ? this.getOldStringId() : this.getNewStringId();
    }

    @Override
    public String getNewStringId() {
        return this.newStringId;
    }

    @Override
    public String getOldStringId() {
        return this.oldStringId;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @Override
    public SpongeBlockType readContainer(ValueContainer<?> valueContainer) {
        return this;
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        return itemStack;
    }

    public BlockState writeBlockState(BlockState blockState) {
        return blockState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeBlockType that = (SpongeBlockType)o;
        return this.numericalId == that.numericalId && this.maxStackSize == that.maxStackSize && Objects.equals(this.oldStringId, that.oldStringId) && Objects.equals(this.newStringId, that.newStringId);
    }

    public int hashCode() {
        return Objects.hash(this.numericalId, this.oldStringId, this.newStringId, this.maxStackSize);
    }
}

