/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumBlockTypeRailShape;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeRail;
import com.degoos.wetsponge.util.Validate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.BlockFace;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Rails;

public class SpigotBlockTypeRail
extends SpigotBlockType
implements WSBlockTypeRail {
    private EnumBlockTypeRailShape shape;
    private Set<EnumBlockTypeRailShape> allowedShapes;

    public SpigotBlockTypeRail(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockTypeRailShape shape, Set<EnumBlockTypeRailShape> allowedShapes) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        Validate.notNull((Object)shape, "Shape cannot be null!");
        this.shape = shape;
        this.allowedShapes = allowedShapes;
    }

    @Override
    public EnumBlockTypeRailShape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(EnumBlockTypeRailShape shape) {
        Validate.notNull((Object)shape, "Shape cannot be null!");
        this.shape = shape;
    }

    @Override
    public Set<EnumBlockTypeRailShape> allowedShapes() {
        return new HashSet<EnumBlockTypeRailShape>(this.allowedShapes);
    }

    @Override
    public SpigotBlockTypeRail clone() {
        return new SpigotBlockTypeRail(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.shape, new HashSet<EnumBlockTypeRailShape>(this.allowedShapes));
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        if (data instanceof Rails) {
            boolean ascending;
            BlockFace face;
            switch (this.shape) {
                case EAST_WEST: {
                    face = BlockFace.EAST;
                    ascending = false;
                    break;
                }
                case NORTH_EAST: {
                    face = BlockFace.NORTH_EAST;
                    ascending = false;
                    break;
                }
                case NORTH_WEST: {
                    face = BlockFace.NORTH_WEST;
                    ascending = false;
                    break;
                }
                case SOUTH_EAST: {
                    face = BlockFace.SOUTH_EAST;
                    ascending = false;
                    break;
                }
                case SOUTH_WEST: {
                    face = BlockFace.SOUTH_WEST;
                    ascending = false;
                    break;
                }
                case ASCENDING_EAST: {
                    face = BlockFace.EAST;
                    ascending = true;
                    break;
                }
                case ASCENDING_WEST: {
                    face = BlockFace.WEST;
                    ascending = true;
                    break;
                }
                case ASCENDING_NORTH: {
                    face = BlockFace.NORTH;
                    ascending = true;
                    break;
                }
                case ASCENDING_SOUTH: {
                    face = BlockFace.SOUTH;
                    ascending = true;
                    break;
                }
                default: {
                    face = BlockFace.NORTH;
                    ascending = false;
                }
            }
            ((Rails)data).setDirection(face, ascending);
        }
        return data;
    }

    @Override
    public SpigotBlockTypeRail readMaterialData(MaterialData materialData) {
        if (materialData instanceof Rails) {
            if (((Rails)materialData).isOnSlope()) {
                switch (((Rails)materialData).getDirection()) {
                    case SOUTH: {
                        this.shape = EnumBlockTypeRailShape.ASCENDING_SOUTH;
                        break;
                    }
                    case WEST: {
                        this.shape = EnumBlockTypeRailShape.ASCENDING_WEST;
                        break;
                    }
                    case EAST: {
                        this.shape = EnumBlockTypeRailShape.ASCENDING_EAST;
                        break;
                    }
                    default: {
                        this.shape = EnumBlockTypeRailShape.ASCENDING_NORTH;
                        break;
                    }
                }
            } else {
                switch (((Rails)materialData).getDirection()) {
                    case SOUTH_WEST: {
                        this.shape = EnumBlockTypeRailShape.SOUTH_WEST;
                        break;
                    }
                    case SOUTH_EAST: {
                        this.shape = EnumBlockTypeRailShape.SOUTH_EAST;
                        break;
                    }
                    case NORTH_WEST: {
                        this.shape = EnumBlockTypeRailShape.NORTH_WEST;
                        break;
                    }
                    case NORTH_EAST: {
                        this.shape = EnumBlockTypeRailShape.NORTH_EAST;
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        this.shape = EnumBlockTypeRailShape.EAST_WEST;
                    }
                    default: {
                        this.shape = EnumBlockTypeRailShape.NORTH_SOUTH;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeRail that = (SpigotBlockTypeRail)o;
        return this.shape == that.shape && Objects.equals(this.allowedShapes, that.allowedShapes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.shape, this.allowedShapes});
    }
}

