/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeMultipleFacing;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeMultipleFacing
extends SpigotBlockType
implements WSBlockTypeMultipleFacing {
    private Set<EnumBlockFace> faces;
    private Set<EnumBlockFace> allowedFaces;

    public SpigotBlockTypeMultipleFacing(int numericalId, String oldStringId, String newStringId, int maxStackSize, Set<EnumBlockFace> faces, Set<EnumBlockFace> allowedFaces) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.faces = faces;
        this.allowedFaces = allowedFaces;
    }

    @Override
    public boolean hasFace(EnumBlockFace face) {
        return this.faces.contains((Object)face);
    }

    @Override
    public void setFace(EnumBlockFace face, boolean enabled) {
        if (enabled) {
            this.faces.add(face);
        } else {
            this.faces.remove((Object)face);
        }
    }

    @Override
    public Set<EnumBlockFace> getFaces() {
        return new HashSet<EnumBlockFace>(this.faces);
    }

    @Override
    public Set<EnumBlockFace> getAllowedFaces() {
        return new HashSet<EnumBlockFace>(this.allowedFaces);
    }

    @Override
    public SpigotBlockTypeMultipleFacing clone() {
        return new SpigotBlockTypeMultipleFacing(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), new HashSet<EnumBlockFace>(this.faces), new HashSet<EnumBlockFace>(this.allowedFaces));
    }

    @Override
    public MaterialData toMaterialData() {
        return super.toMaterialData();
    }

    @Override
    public SpigotBlockTypeMultipleFacing readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeMultipleFacing that = (SpigotBlockTypeMultipleFacing)o;
        return Objects.equals(this.faces, that.faces);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.faces);
    }
}

