/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeLevelled;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeLevelled
extends SpigotBlockType
implements WSBlockTypeLevelled {
    private int level;
    private int maximumLevel;

    public SpigotBlockTypeLevelled(int numericalId, String oldStringId, String newStringId, int maxStackSize, int level, int maximumLevel) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.level = level;
        this.maximumLevel = maximumLevel;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = Math.min(this.maximumLevel, Math.max(0, level));
    }

    @Override
    public int getMaximumLevel() {
        return this.maximumLevel;
    }

    @Override
    public SpigotBlockTypeLevelled clone() {
        return new SpigotBlockTypeLevelled(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.level, this.maximumLevel);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData((byte)this.level);
        return data;
    }

    @Override
    public SpigotBlockTypeLevelled readMaterialData(MaterialData materialData) {
        this.level = materialData.getData();
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeLevelled that = (SpigotBlockTypeLevelled)o;
        return this.level == that.level && this.maximumLevel == that.maximumLevel;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.level, this.maximumLevel);
    }
}

