/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.EnumDyeColor;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeDyeColored;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.DyeColor;
import org.bukkit.material.Colorable;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeDyeColored
extends SpigotBlockType
implements WSBlockTypeDyeColored {
    private EnumDyeColor dyeColor;

    public SpigotBlockTypeDyeColored(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumDyeColor dyeColor) {
        super(numericalId, oldStringId, newStringId.startsWith("minecraft:") ? newStringId.substring(10) : newStringId, maxStackSize);
        Validate.notNull((Object)dyeColor, "Dye color cannot be null!");
        this.dyeColor = dyeColor;
    }

    @Override
    public String getNewStringId() {
        return "minecraft:" + this.dyeColor.getMinecraftName().toLowerCase() + "_" + super.getNewStringId();
    }

    @Override
    public EnumDyeColor getDyeColor() {
        return this.dyeColor;
    }

    @Override
    public void setDyeColor(EnumDyeColor dyeColor) {
        Validate.notNull((Object)dyeColor, "Dye color cannot be null!");
        this.dyeColor = dyeColor;
    }

    @Override
    public SpigotBlockTypeDyeColored clone() {
        return new SpigotBlockTypeDyeColored(this.getNumericalId(), this.getOldStringId(), super.getNewStringId(), this.getMaxStackSize(), this.dyeColor);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        if (data instanceof Colorable) {
            ((Colorable)data).setColor(DyeColor.getByDyeData((byte)this.dyeColor.getDyeData()));
        } else {
            data.setData(this.dyeColor.getWoolData());
        }
        return data;
    }

    @Override
    public SpigotBlockTypeDyeColored readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        this.dyeColor = materialData instanceof Colorable ? EnumDyeColor.getByDyeData(((Colorable)materialData).getColor().getDyeData()).orElse(EnumDyeColor.WHITE) : EnumDyeColor.getByWoolData(materialData.getData()).orElse(EnumDyeColor.WHITE);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeDyeColored that = (SpigotBlockTypeDyeColored)o;
        return this.dyeColor == that.dyeColor;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.dyeColor});
    }
}

