/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeDirectional;
import com.degoos.wetsponge.util.Validate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.BlockFace;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeDirectional
extends SpigotBlockType
implements WSBlockTypeDirectional {
    private EnumBlockFace facing;
    private Set<EnumBlockFace> faces;

    public SpigotBlockTypeDirectional(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace facing, Set<EnumBlockFace> faces) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        Validate.notNull((Object)facing, "Facing cannot be null!");
        this.facing = facing;
        this.faces = faces;
    }

    @Override
    public EnumBlockFace getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumBlockFace blockFace) {
        Validate.notNull((Object)blockFace, "Facing cannot be null!");
        this.facing = blockFace;
    }

    @Override
    public Set<EnumBlockFace> getFaces() {
        return new HashSet<EnumBlockFace>(this.faces);
    }

    @Override
    public SpigotBlockTypeDirectional clone() {
        return new SpigotBlockTypeDirectional(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.facing, new HashSet<EnumBlockFace>(this.faces));
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        if (data instanceof Directional) {
            ((Directional)data).setFacingDirection(BlockFace.valueOf((String)this.facing.name()));
        }
        return data;
    }

    @Override
    public SpigotBlockTypeDirectional readMaterialData(MaterialData materialData) {
        if (materialData instanceof Directional) {
            this.facing = EnumBlockFace.valueOf(((Directional)materialData).getFacing().name());
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeDirectional that = (SpigotBlockTypeDirectional)o;
        return this.facing == that.facing;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.facing});
    }
}

