/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeAnaloguePowerable;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeAnaloguePowerable
extends SpigotBlockType
implements WSBlockTypeAnaloguePowerable {
    private int power;
    private int maximumPower;

    public SpigotBlockTypeAnaloguePowerable(int numericalId, String oldStringId, String newStringId, int maxStackSize, int power, int maximumPower) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.power = power;
        this.maximumPower = maximumPower;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void setPower(int power) {
        this.power = Math.min(this.maximumPower, Math.max(0, power));
    }

    @Override
    public int gerMaximumPower() {
        return this.maximumPower;
    }

    @Override
    public SpigotBlockTypeAnaloguePowerable clone() {
        return new SpigotBlockTypeAnaloguePowerable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.power, this.maximumPower);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData((byte)this.power);
        return data;
    }

    @Override
    public SpigotBlockTypeAnaloguePowerable readMaterialData(MaterialData materialData) {
        this.power = materialData.getData();
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeAnaloguePowerable that = (SpigotBlockTypeAnaloguePowerable)o;
        return this.power == that.power && this.maximumPower == that.maximumPower;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.power, this.maximumPower);
    }
}

