/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeAgeable;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeAgeable
extends SpigotBlockType
implements WSBlockTypeAgeable {
    private int age;
    private int maximumAge;

    public SpigotBlockTypeAgeable(int numericalId, String oldStringId, String newStringId, int maxStackSize, int age, int maximumAge) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.age = age;
        this.maximumAge = maximumAge;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int age) {
        this.age = Math.min(this.maximumAge, Math.max(0, age));
    }

    @Override
    public int getMaximumAge() {
        return this.maximumAge;
    }

    @Override
    public SpigotBlockTypeAgeable clone() {
        return new SpigotBlockTypeAgeable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.age, this.maximumAge);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData((byte)this.age);
        return data;
    }

    @Override
    public SpigotBlockTypeAgeable readMaterialData(MaterialData materialData) {
        this.age = materialData.getData();
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeAgeable that = (SpigotBlockTypeAgeable)o;
        return this.age == that.age && this.maximumAge == that.maximumAge;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.age, this.maximumAge);
    }
}

