/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.material.SpigotMaterial;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public class SpigotBlockType
implements SpigotMaterial,
WSBlockType {
    private int numericalId;
    private String oldStringId;
    private String newStringId;
    private int maxStackSize;

    public SpigotBlockType(int numericalId, String oldStringId, String newStringId, int maxStackSize) {
        this.numericalId = numericalId < 0 ? -1 : numericalId;
        this.oldStringId = oldStringId == null || oldStringId.equals("") ? null : oldStringId;
        this.newStringId = newStringId;
        this.maxStackSize = Math.max(1, maxStackSize);
    }

    @Override
    public SpigotBlockType clone() {
        return new SpigotBlockType(this.numericalId, this.oldStringId, this.newStringId, this.maxStackSize);
    }

    @Override
    public int getNumericalId() {
        return this.numericalId;
    }

    @Override
    public String getStringId() {
        return WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13) ? this.getOldStringId() : this.getNewStringId();
    }

    @Override
    public String getNewStringId() {
        return this.newStringId;
    }

    @Override
    public String getOldStringId() {
        return this.oldStringId;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @Override
    public MaterialData toMaterialData() {
        return Material.getMaterial((int)this.getNumericalId()).getNewData((byte)0);
    }

    @Override
    public SpigotBlockType readMaterialData(MaterialData materialData) {
        return this;
    }

    @Override
    public void writeItemMeta(ItemMeta itemMeta) {
        if (itemMeta instanceof BlockStateMeta) {
            BlockState state = ((BlockStateMeta)itemMeta).getBlockState();
            if (state == null) {
                return;
            }
            state.setData(this.toMaterialData());
            ((BlockStateMeta)itemMeta).setBlockState(state);
        }
    }

    @Override
    public void readItemMeta(ItemMeta itemMeta) {
        if (itemMeta instanceof BlockStateMeta) {
            BlockState state = ((BlockStateMeta)itemMeta).getBlockState();
            if (state == null) {
                return;
            }
            MaterialData data = state.getData();
            if (data != null) {
                this.readMaterialData(data);
            }
        }
    }

    @Override
    public void writeNBTTag(WSNBTTagCompound compound) {
    }

    @Override
    public void readNBTTag(WSNBTTagCompound compound) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpigotBlockType that = (SpigotBlockType)o;
        return this.numericalId == that.numericalId && this.maxStackSize == that.maxStackSize && Objects.equals(this.oldStringId, that.oldStringId) && Objects.equals(this.newStringId, that.newStringId);
    }

    public int hashCode() {
        return Objects.hash(this.numericalId, this.oldStringId, this.newStringId, this.maxStackSize);
    }
}

