/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeSnowable;
import com.degoos.wetsponge.util.Spigot13MaterialUtils;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Snowable;

public class Spigot13BlockTypeSnowable
extends Spigot13BlockType
implements WSBlockTypeSnowable {
    public boolean snowy;

    public Spigot13BlockTypeSnowable(int numericalId, String oldStringId, String newStringId, int maxStackSize, boolean snowy) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.snowy = snowy;
    }

    @Override
    public boolean isSnowy() {
        return this.snowy;
    }

    @Override
    public void setSnowy(boolean snowy) {
        this.snowy = snowy;
    }

    @Override
    public Spigot13BlockTypeSnowable clone() {
        return new Spigot13BlockTypeSnowable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.snowy);
    }

    @Override
    public BlockData toBlockData() {
        Material material = Spigot13MaterialUtils.getByKey(this.getNewStringId()).orElse(null);
        if (material == null) {
            return null;
        }
        BlockData data = material.createBlockData();
        if (data instanceof Snowable) {
            ((Snowable)data).setSnowy(this.snowy);
        }
        return data;
    }

    @Override
    public Spigot13BlockTypeSnowable readBlockData(BlockData blockData) {
        if (blockData instanceof Snowable) {
            this.snowy = ((Snowable)blockData).isSnowy();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeSnowable that = (Spigot13BlockTypeSnowable)o;
        return this.snowy == that.snowy;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.snowy);
    }
}

