/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeRotatable;
import com.degoos.wetsponge.util.Spigot13MaterialUtils;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;

public class Spigot13BlockTypeRotatable
extends Spigot13BlockType
implements WSBlockTypeRotatable {
    private EnumBlockFace rotation;

    public Spigot13BlockTypeRotatable(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace rotation) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.rotation = rotation;
    }

    @Override
    public EnumBlockFace getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(EnumBlockFace rotation) {
        Validate.notNull((Object)rotation, "Rotation cannot be null!");
        this.rotation = rotation;
    }

    @Override
    public Spigot13BlockTypeRotatable clone() {
        return new Spigot13BlockTypeRotatable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.rotation);
    }

    @Override
    public BlockData toBlockData() {
        Material material = Spigot13MaterialUtils.getByKey(this.getNewStringId()).orElse(null);
        if (material == null) {
            return null;
        }
        BlockData data = material.createBlockData();
        if (data instanceof Rotatable) {
            ((Rotatable)data).setRotation(BlockFace.valueOf((String)this.rotation.name()));
        }
        return data;
    }

    @Override
    public Spigot13BlockTypeRotatable readBlockData(BlockData blockData) {
        if (blockData instanceof Rotatable) {
            this.rotation = EnumBlockFace.valueOf(((Rotatable)blockData).getRotation().name());
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeRotatable that = (Spigot13BlockTypeRotatable)o;
        return this.rotation == that.rotation;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.rotation});
    }
}

