/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeMultipleFacing;
import com.degoos.wetsponge.util.Spigot13MaterialUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;

public class Spigot13BlockTypeMultipleFacing
extends Spigot13BlockType
implements WSBlockTypeMultipleFacing {
    private Set<EnumBlockFace> faces;
    private Set<EnumBlockFace> allowedFaces;

    public Spigot13BlockTypeMultipleFacing(int numericalId, String oldStringId, String newStringId, int maxStackSize, Set<EnumBlockFace> faces, Set<EnumBlockFace> allowedFaces) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.faces = faces;
        this.allowedFaces = allowedFaces;
    }

    @Override
    public boolean hasFace(EnumBlockFace face) {
        return this.faces.contains((Object)face);
    }

    @Override
    public void setFace(EnumBlockFace face, boolean enabled) {
        if (enabled) {
            this.faces.add(face);
        } else {
            this.faces.remove((Object)face);
        }
    }

    @Override
    public Set<EnumBlockFace> getFaces() {
        return new HashSet<EnumBlockFace>(this.faces);
    }

    @Override
    public Set<EnumBlockFace> getAllowedFaces() {
        return new HashSet<EnumBlockFace>(this.allowedFaces);
    }

    @Override
    public Spigot13BlockTypeMultipleFacing clone() {
        return new Spigot13BlockTypeMultipleFacing(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), new HashSet<EnumBlockFace>(this.faces), new HashSet<EnumBlockFace>(this.allowedFaces));
    }

    @Override
    public BlockData toBlockData() {
        Material material = Spigot13MaterialUtils.getByKey(this.getNewStringId()).orElse(null);
        if (material == null) {
            return null;
        }
        BlockData data = material.createBlockData();
        if (data instanceof MultipleFacing) {
            ((MultipleFacing)data).getFaces().forEach(target -> ((MultipleFacing)data).setFace(target, false));
            this.faces.forEach(target -> ((MultipleFacing)data).setFace(BlockFace.valueOf((String)target.name()), true));
        }
        return data;
    }

    @Override
    public Spigot13BlockTypeMultipleFacing readBlockData(BlockData blockData) {
        if (blockData instanceof MultipleFacing) {
            this.faces = ((MultipleFacing)blockData).getFaces().stream().map(target -> EnumBlockFace.valueOf(target.name())).collect(Collectors.toSet());
            this.allowedFaces = ((MultipleFacing)blockData).getAllowedFaces().stream().map(target -> EnumBlockFace.valueOf(target.name())).collect(Collectors.toSet());
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeMultipleFacing that = (Spigot13BlockTypeMultipleFacing)o;
        return Objects.equals(this.faces, that.faces);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.faces);
    }
}

