/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeLevelled;
import com.degoos.wetsponge.util.Spigot13MaterialUtils;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;

public class Spigot13BlockTypeLevelled
extends Spigot13BlockType
implements WSBlockTypeLevelled {
    private int level;
    private int maximumLevel;

    public Spigot13BlockTypeLevelled(int numericalId, String oldStringId, String newStringId, int maxStackSize, int level, int maximumLevel) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.level = level;
        this.maximumLevel = maximumLevel;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = Math.min(this.maximumLevel, Math.max(0, level));
    }

    @Override
    public int getMaximumLevel() {
        return this.maximumLevel;
    }

    @Override
    public Spigot13BlockTypeLevelled clone() {
        return new Spigot13BlockTypeLevelled(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.level, this.maximumLevel);
    }

    @Override
    public BlockData toBlockData() {
        Material material = Spigot13MaterialUtils.getByKey(this.getNewStringId()).orElse(null);
        if (material == null) {
            return null;
        }
        BlockData data = material.createBlockData();
        if (data instanceof Levelled) {
            ((Levelled)data).setLevel(this.level);
        }
        return data;
    }

    @Override
    public Spigot13BlockTypeLevelled readBlockData(BlockData blockData) {
        if (blockData instanceof Levelled) {
            this.level = ((Levelled)blockData).getLevel();
            this.maximumLevel = ((Levelled)blockData).getMaximumLevel();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeLevelled that = (Spigot13BlockTypeLevelled)o;
        return this.level == that.level && this.maximumLevel == that.maximumLevel;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.level, this.maximumLevel);
    }
}

