/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.WSItemTypes;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.material.item.WSItemType;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import java.util.Optional;

public interface WSMaterial {
    public WSMaterial clone();

    public int getNumericalId();

    public String getStringId();

    public String getNewStringId();

    public String getOldStringId();

    public int getMaxStackSize();

    public WSNBTTagCompound writeToData(WSNBTTagCompound var1);

    public WSNBTTagCompound readFromData(WSNBTTagCompound var1);

    public static Optional<? extends WSMaterial> getById(String string) {
        Optional<WSMaterial> optional;
        if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
            optional = WSBlockTypes.getByOldId(string);
            if (!optional.isPresent()) {
                optional = WSItemTypes.getByOldId(string);
            }
            if (!optional.isPresent()) {
                optional = WSBlockTypes.getByNewId(string);
            }
            if (!optional.isPresent()) {
                optional = WSItemTypes.getByNewId(string);
            }
        } else {
            optional = WSBlockTypes.getByNewId(string);
            if (!optional.isPresent()) {
                optional = WSItemTypes.getByNewId(string);
            }
            if (!optional.isPresent()) {
                optional = WSBlockTypes.getByOldId(string);
            }
            if (!optional.isPresent()) {
                optional = WSItemTypes.getByOldId(string);
            }
        }
        return optional;
    }

    public static Optional<? extends WSMaterial> getById(int id) {
        Optional<WSMaterial> optional = WSBlockTypes.getById(id);
        if (!optional.isPresent()) {
            optional = WSItemTypes.getById(id);
        }
        return optional;
    }

    public static Class<? extends WSMaterial> getMaterialClass(WSMaterial material) {
        String id = material.getStringId();
        if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
            Optional<WSBlockTypes> blockTypes = WSBlockTypes.getBlockTypesByNewId(id);
            if (blockTypes.isPresent()) {
                return blockTypes.get().getMaterialClass();
            }
            Optional<WSItemTypes> itemTypes = WSItemTypes.getItemTypesByNewId(id);
            if (itemTypes.isPresent()) {
                return itemTypes.get().getMaterialClass();
            }
            blockTypes = WSBlockTypes.getBlockTypesByOldId(id);
            if (blockTypes.isPresent()) {
                return blockTypes.get().getMaterialClass();
            }
            itemTypes = WSItemTypes.getItemTypesByOldId(id);
            if (itemTypes.isPresent()) {
                return itemTypes.get().getMaterialClass();
            }
        } else {
            Optional<WSBlockTypes> blockTypes = WSBlockTypes.getBlockTypesByOldId(id);
            if (blockTypes.isPresent()) {
                return blockTypes.get().getMaterialClass();
            }
            Optional<WSItemTypes> itemTypes = WSItemTypes.getItemTypesByOldId(id);
            if (itemTypes.isPresent()) {
                return itemTypes.get().getMaterialClass();
            }
            blockTypes = WSBlockTypes.getBlockTypesByNewId(id);
            if (blockTypes.isPresent()) {
                return blockTypes.get().getMaterialClass();
            }
            itemTypes = WSItemTypes.getItemTypesByNewId(id);
            if (itemTypes.isPresent()) {
                return itemTypes.get().getMaterialClass();
            }
        }
        if (material instanceof WSBlockType) {
            return WSBlockType.class;
        }
        if (material instanceof WSItemType) {
            return WSItemType.class;
        }
        return null;
    }
}

