/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.map;

import com.degoos.wetsponge.map.WSMapCharacterSprite;
import java.util.HashMap;

public class WSMapFont {
    private final HashMap<Character, WSMapCharacterSprite> chars = new HashMap();
    private int height = 0;
    protected boolean malleable = true;

    public void setChar(char ch, WSMapCharacterSprite sprite) {
        if (!this.malleable) {
            throw new IllegalStateException("this font is not malleable");
        }
        this.chars.put(Character.valueOf(ch), sprite);
        if (sprite.getHeight() > this.height) {
            this.height = sprite.getHeight();
        }
    }

    public WSMapCharacterSprite getChar(char ch) {
        return this.chars.get(Character.valueOf(ch));
    }

    public int getWidth(String text) {
        if (!this.isValid(text)) {
            throw new IllegalArgumentException("text contains invalid characters");
        }
        if (text.length() == 0) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\u00a7') continue;
            result += this.chars.get(Character.valueOf(ch)).getWidth();
        }
        return result += text.length() - 1;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isValid(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\u00a7' || ch == '\n' || this.chars.get(Character.valueOf(ch)) != null) continue;
            return false;
        }
        return true;
    }
}

