/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.listener.sponge;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.block.SpongeBlockSnapshot;
import com.degoos.wetsponge.block.WSBlockSnapshot;
import com.degoos.wetsponge.data.WSTransaction;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.event.block.WSBlockBreakEvent;
import com.degoos.wetsponge.event.block.WSBlockChangeEvent;
import com.degoos.wetsponge.event.block.WSBlockModifyEvent;
import com.degoos.wetsponge.event.block.WSBlockPlaceEvent;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.world.SpongeLocation;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SpongeBlockListener {
    @Listener(order=Order.FIRST)
    public void onBlockChange(ChangeBlockEvent event) {
        try {
            Optional<WSPlayer> player = event.getCause().first(Player.class).map(target -> WetSponge.getServer().getPlayer(target.getUniqueId()).orElseThrow(NullPointerException::new));
            for (Transaction transaction : event.getTransactions()) {
                WSTransaction<WSBlockSnapshot> blockTransaction = new WSTransaction<WSBlockSnapshot>(new SpongeBlockSnapshot((BlockSnapshot)transaction.getOriginal()), new SpongeBlockSnapshot((BlockSnapshot)transaction.getFinal()));
                SpongeLocation location = new SpongeLocation((Location<World>)((Location)((BlockSnapshot)transaction.getOriginal()).getLocation().orElse(null)));
                WSBlockChangeEvent wetSpongeEvent = event instanceof ChangeBlockEvent.Break ? new WSBlockBreakEvent(blockTransaction, location, player) : (event instanceof ChangeBlockEvent.Place ? new WSBlockPlaceEvent(blockTransaction, location, player) : (event instanceof ChangeBlockEvent.Modify ? new WSBlockModifyEvent(blockTransaction, location, player) : new WSBlockChangeEvent(blockTransaction, location)));
                WetSponge.getEventManager().callEvent(wetSpongeEvent);
                transaction.setValid(!wetSpongeEvent.isCancelled());
                if (!blockTransaction.getNewData().hasChanged()) continue;
                transaction.setCustom((DataSerializable)((BlockSnapshot)transaction.getFinal()).withState(((SpongeBlockType)blockTransaction.getNewData().getMaterial()).writeBlockState(((BlockType)Sponge.getRegistry().getType(BlockType.class, blockTransaction.getNewData().getMaterial().getStringId()).get()).getDefaultState())));
            }
            if (event.getTransactions().stream().noneMatch(Transaction::isValid)) {
                event.setCancelled(true);
            }
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was parsing the event Sponge-ChangeBlockEvent!");
        }
    }
}

