/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.listener.spigot;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.entity.living.player.Spigot13Player;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.event.entity.player.connection.WSPlayerReceivePacketEvent;
import com.degoos.wetsponge.event.entity.player.connection.WSPlayerSendPacketEvent;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.packet.WSPacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketBlockChange;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityMetadata;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityProperties;
import com.degoos.wetsponge.packet.play.server.WSSPacketMaps;
import com.degoos.wetsponge.packet.play.server.WSSPacketMultiBlockChange;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnMob;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnPlayer;
import com.degoos.wetsponge.parser.entity.Spigot13EntityParser;
import com.degoos.wetsponge.parser.packet.Spigot13PacketParser;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.world.WSLocation;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class Spigot13PacketListener
extends ChannelDuplexHandler {
    private WSPlayer player;

    public Spigot13PacketListener(WSPlayer player) {
        this.player = player;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        try {
            WSPlayer player;
            WSEntity target2;
            WSLivingEntity entity;
            WSPacket finalPacket;
            WSPacket packet = finalPacket = Spigot13PacketParser.parse(msg);
            if (packet instanceof WSSPacketBlockChange) {
                this.player.getFakeBlock(WSLocation.of(this.player.getWorld(), ((WSSPacketBlockChange)packet).getBlockPosition())).ifPresent(((WSSPacketBlockChange)packet)::setMaterial);
            }
            if (packet instanceof WSSPacketMultiBlockChange) {
                Vector2i chunk = ((WSSPacketMultiBlockChange)packet).getChunkPosition();
                Map<WSLocation, WSBlockType> fakeBlocks = this.player.getFakeBlocks();
                if (!fakeBlocks.isEmpty() && fakeBlocks.keySet().stream().anyMatch(target -> chunk.getX() == target.getBlockX() >> 4 && chunk.getY() == target.getBlockZ() >> 4)) {
                    new HashMap<Vector3i, WSBlockType>(((WSSPacketMultiBlockChange)packet).getMaterials()).forEach((vector3i, type) -> {
                        WSLocation location = WSLocation.of(this.player.getWorld(), vector3i.add(chunk.getX() * 16, 0, chunk.getY() * 16));
                        this.player.getFakeBlock(location).ifPresent(blockType -> ((WSSPacketMultiBlockChange)finalPacket).addMaterial(location.toVector3i(), (WSBlockType)blockType));
                    });
                }
            }
            if (packet instanceof WSSPacketSpawnMob) {
                entity = ((WSSPacketSpawnMob)packet).getEntity().orElse(null);
                if (entity == null && (target2 = (WSEntity)Spigot13EntityParser.getWSEntity(((WSSPacketSpawnMob)packet).getUniqueId()).orElse(null)) != null && target2 instanceof WSLivingEntity) {
                    entity = (WSLivingEntity)target2;
                }
                if (!(entity == null || entity instanceof WSPlayer && ((WSPlayer)entity).getName().equals(this.player.getName()) || !entity.hasDisguise())) {
                    ((WSSPacketSpawnMob)packet).setDisguise(entity.getDisguise().get());
                }
            }
            if (packet instanceof WSSPacketSpawnPlayer && (player = (WSPlayer)WetSponge.getServer().getPlayer(((WSSPacketSpawnPlayer)packet).getUniqueId()).orElse(null)) != null && player.hasDisguise() && !player.getName().equals(this.player.getName())) {
                packet = WSSPacketSpawnMob.of(player.getDisguise().get(), ((WSSPacketSpawnPlayer)packet).getPosition(), player.getVelocity(), player.getRotation().toVector2(), (float)player.getHeadRotation().getY());
                ((WSSPacketSpawnMob)packet).setEntityId(player.getEntityId());
                ((WSSPacketSpawnMob)packet).setUniqueId(player.getUniqueId());
            }
            if (packet instanceof WSSPacketEntityMetadata) {
                entity = null;
                target2 = Spigot13EntityParser.getWSEntity(((WSSPacketEntityMetadata)packet).getEntityId()).orElse(null);
                if (target2 != null && target2 instanceof WSLivingEntity) {
                    entity = (WSLivingEntity)target2;
                }
                if (!(entity == null || entity instanceof WSPlayer && ((WSPlayer)entity).getName().equals(this.player.getName()) || !entity.hasDisguise())) {
                    ((WSSPacketEntityMetadata)packet).setMetadataOf(entity.getDisguise().get());
                }
            }
            if (packet instanceof WSSPacketEntityProperties) {
                entity = null;
                target2 = Spigot13EntityParser.getWSEntity(((WSSPacketEntityProperties)packet).getEntityId()).orElse(null);
                if (target2 != null && target2 instanceof WSLivingEntity) {
                    entity = (WSLivingEntity)target2;
                }
                if (!(entity == null || entity instanceof WSPlayer && ((WSPlayer)entity).getName().equals(this.player.getName()) || !entity.hasDisguise())) {
                    ((WSSPacketEntityProperties)packet).setPropertiesOf(entity.getDisguise().get());
                }
            }
            if (packet instanceof WSSPacketMaps) {
                this.player.getWorld().getMapView(((WSSPacketMaps)packet).getMapId()).ifPresent(((WSSPacketMaps)packet)::setMapView);
            }
            WSPlayerSendPacketEvent event = new WSPlayerSendPacketEvent(this.player, packet);
            WetSponge.getEventManager().callEvent(event);
            if (event.isCancelled()) {
                return;
            }
            if (event.getPacket().hasChanged()) {
                event.getPacket().update();
            }
            super.write(ctx, event.getPacket().getHandler(), promise);
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was writing a Spigot packet!");
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            WSPacket packet = Spigot13PacketParser.parse(msg);
            WSPlayerReceivePacketEvent event = new WSPlayerReceivePacketEvent(this.player, packet);
            WetSponge.getEventManager().callEvent(event);
            if (event.isCancelled()) {
                return;
            }
            if (event.getPacket().hasChanged()) {
                event.getPacket().update();
            }
            super.channelRead(ctx, event.getPacket().getHandler());
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was reading a Spigot packet!");
        }
    }

    public static void inject(WSPlayer player) {
        new Thread(() -> {
            Player p = ((Spigot13Player)player).getHandled();
            try {
                Object craftHandle = ReflectionUtils.invokeMethod((Object)p, p.getClass(), "getHandle", new Object[0]);
                Object playerCon = ReflectionUtils.getObject(craftHandle, "playerConnection");
                Object manager = ReflectionUtils.getObject(playerCon, "networkManager");
                Channel channel = ReflectionUtils.getFirstObject(manager.getClass(), Channel.class, manager);
                if (channel.pipeline().context("WetSponge") != null) {
                    channel.pipeline().remove("WetSponge");
                }
                channel.pipeline().addBefore("packet_handler", "WetSponge", (ChannelHandler)new Spigot13PacketListener(player));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }).start();
    }

    public static void uninject(WSPlayer player) {
        new Thread(() -> {
            Player p = ((Spigot13Player)player).getHandled();
            try {
                Object craftHandle = ReflectionUtils.invokeMethod((Object)p, p.getClass(), "getHandle", new Object[0]);
                Object playerCon = ReflectionUtils.getObject(craftHandle, "playerConnection");
                Object manager = ReflectionUtils.getObject(playerCon, "networkManager");
                Channel channel = ReflectionUtils.getFirstObject(manager.getClass(), Channel.class, manager);
                if (channel.pipeline().context("WetSponge") != null) {
                    channel.pipeline().remove("WetSponge");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }).start();
    }
}

