/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.item.enchantment;

import com.degoos.wetsponge.item.Spigot13ItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.item.enchantment.WSEnchantment;
import com.degoos.wetsponge.item.enchantment.WSEnchantmentPrototype;
import com.degoos.wetsponge.text.translation.WSTranslation;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.inventory.ItemStack;

public class Spigot13Enchantment
implements WSEnchantment {
    private Enchantment enchantment;

    public Spigot13Enchantment(Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    public Spigot13Enchantment(String name) {
        String[] split = name.split(":");
        this.enchantment = split.length == 1 ? Enchantment.getByKey((NamespacedKey)new NamespacedKey("minecraft", split[0])) : Enchantment.getByKey((NamespacedKey)new NamespacedKey(split[0], split[1]));
        if (this.enchantment == null) {
            this.enchantment = Enchantment.PROTECTION_ENVIRONMENTAL;
        }
    }

    public Spigot13Enchantment(String key, final String name, final int minimumLevel, final int maximumLevel, final WSEnchantmentPrototype prototype) {
        String[] split = name.split(":");
        NamespacedKey namespacedKey = split.length == 1 ? new NamespacedKey("minecraft", split[0]) : new NamespacedKey(split[0], split[1]);
        this.enchantment = new Enchantment(namespacedKey){

            public String getName() {
                return name;
            }

            public int getMaxLevel() {
                return maximumLevel;
            }

            public int getStartLevel() {
                return minimumLevel;
            }

            public EnchantmentTarget getItemTarget() {
                return EnchantmentTarget.ALL;
            }

            public boolean isTreasure() {
                return false;
            }

            public boolean isCursed() {
                return false;
            }

            public boolean conflictsWith(Enchantment enchantment) {
                return !prototype.isCompatibleWith(new Spigot13Enchantment(enchantment));
            }

            public boolean canEnchantItem(ItemStack itemStack) {
                return prototype.canBeAppliedToStack(new Spigot13ItemStack(itemStack));
            }
        };
    }

    @Override
    public WSTranslation getTranslation() {
        throw new IllegalAccessError("Not supported by Spigot");
    }

    @Override
    public String getName() {
        return this.enchantment.getKey().toString();
    }

    @Override
    public int getMaximumLevel() {
        return this.enchantment.getMaxLevel();
    }

    @Override
    public int getMinimumLevel() {
        return this.enchantment.getStartLevel();
    }

    @Override
    public boolean canBeAppliedToStack(WSItemStack itemStack) {
        return this.enchantment.canEnchantItem(((Spigot13ItemStack)itemStack).getHandled());
    }

    @Override
    public boolean isCompatibleWith(WSEnchantment enchantment) {
        return !this.enchantment.conflictsWith(((Spigot13Enchantment)enchantment).getHandled());
    }

    public Enchantment getHandled() {
        return this.enchantment;
    }
}

