/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.item;

import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.item.enchantment.SpongeEnchantment;
import com.degoos.wetsponge.item.enchantment.WSEnchantment;
import com.degoos.wetsponge.material.SpongeMaterial;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.WSMaterial;
import com.degoos.wetsponge.nbt.SpongeNBTTagCompound;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.resource.sponge.SpongeSkullBuilder;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.text.translation.SpongeTranslation;
import com.degoos.wetsponge.text.translation.WSTranslation;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeItemStack
implements WSItemStack {
    private ItemStack itemStack;
    private SpongeText displayName;
    private List<WSText> lore;
    private WSMaterial material;
    private int quantity;
    private boolean unbreakable;
    private boolean hideEnchantments;
    private boolean hideAttributes;
    private boolean hideUnbreakable;
    private boolean hideCanDestroy;
    private boolean hideCanBePlacedOn;
    private boolean hidePotionEffects;
    private WSTranslation translation;

    public static SpongeItemStack fromFormat(String format) {
        return new SpongeItemStack(SpongeSkullBuilder.createItemStackByUnknownFormat(format));
    }

    public SpongeItemStack(ItemStack itemStack) {
        Validate.notNull(itemStack, "ItemStack cannot be null!");
        this.itemStack = itemStack;
        this.refresh();
    }

    public SpongeItemStack(WSMaterial material) {
        Validate.notNull(material, "Material cannot be null!");
        this.material = material;
        this.displayName = null;
        this.lore = new ArrayList<WSText>();
        this.quantity = 1;
        try {
            this.itemStack = ItemStack.of((ItemType)((ItemType)Sponge.getRegistry().getType(ItemType.class, material.getStringId()).get()), (int)1);
        }
        catch (NoSuchElementException ex) {
            InternalLogger.printException((Throwable)ex, material.getStringId());
            Sponge.getRegistry().getAllOf(ItemType.class).forEach(target -> InternalLogger.sendWarning(target.getId()));
        }
        this.update();
    }

    public SpongeItemStack(String nbt) throws Exception {
        this(WSNBTTagCompound.of(nbt));
    }

    public SpongeItemStack(WSNBTTagCompound nbt) {
        Validate.notNull(nbt, "NBT cannot be null!");
        if (!nbt.hasKey("id")) {
            throw new NullPointerException("NBTTagCompound doesn't contain key id!");
        }
        WSMaterial.getById(nbt.getString("id")).ifPresent(material -> nbt.setString("id", material.getStringId()));
        this.itemStack = (ItemStack)new net.minecraft.item.ItemStack((NBTTagCompound)nbt.getHandled());
        this.refresh();
    }

    public static WSItemStack of(WSMaterial material) {
        return new SpongeItemStack(material);
    }

    @Override
    public WSText getDisplayName() {
        return this.displayName;
    }

    @Override
    public SpongeItemStack setDisplayName(WSText displayName) {
        this.displayName = (SpongeText)displayName;
        return this;
    }

    @Override
    public List<WSText> getLore() {
        return this.lore;
    }

    @Override
    public SpongeItemStack setLore(List<WSText> lore) {
        this.lore = lore == null ? new ArrayList<WSText>() : new ArrayList<WSText>(lore);
        return this;
    }

    @Override
    public WSItemStack addLoreLine(WSText line) {
        this.lore.add(line == null ? WSText.empty() : line);
        return this;
    }

    @Override
    public WSItemStack clearLore() {
        this.lore.clear();
        return this;
    }

    @Override
    public Map<WSEnchantment, Integer> getEnchantments() {
        HashMap<WSEnchantment, Integer> map = new HashMap<WSEnchantment, Integer>();
        ((List)this.getHandled().get(Keys.ITEM_ENCHANTMENTS).orElse(new ArrayList())).forEach(itemEnchantment -> map.put(new SpongeEnchantment(itemEnchantment.getType()), itemEnchantment.getLevel()));
        return map;
    }

    @Override
    public Optional<Integer> getEnchantmentLevel(WSEnchantment enchantment) {
        Map<WSEnchantment, Integer> enchantments = this.getEnchantments();
        return Optional.ofNullable(enchantments.get(enchantment));
    }

    @Override
    public boolean containsEnchantment(WSEnchantment enchantment) {
        return this.getEnchantments().containsKey(enchantment);
    }

    @Override
    public WSItemStack addEnchantment(WSEnchantment enchantment, int level) {
        List list = this.getHandled().get(Keys.ITEM_ENCHANTMENTS).orElse(new ArrayList());
        list.add(Enchantment.of((EnchantmentType)((SpongeEnchantment)enchantment).getHandled(), (int)level));
        this.getHandled().offer(Keys.ITEM_ENCHANTMENTS, (Object)list);
        return this;
    }

    @Override
    public WSItemStack removeEnchantment(WSEnchantment enchantment) {
        List list = this.getHandled().get(Keys.ITEM_ENCHANTMENTS).orElse(new ArrayList());
        list.stream().filter(target -> target.getType().equals(((SpongeEnchantment)enchantment).getHandled())).forEach(list::remove);
        this.getHandled().offer(Keys.ITEM_ENCHANTMENTS, (Object)list);
        return this;
    }

    @Override
    public WSItemStack clearEnchantments() {
        this.getHandled().offer(Keys.ITEM_ENCHANTMENTS, new ArrayList());
        return this;
    }

    @Override
    public WSMaterial getMaterial() {
        return this.material;
    }

    @Override
    public WSItemStack setMaterial(WSMaterial material) {
        this.material = material;
        return this;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public SpongeItemStack setQuantity(int quantity) {
        this.quantity = quantity;
        return this;
    }

    @Override
    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    @Override
    public WSItemStack setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    @Override
    public boolean isHidingEnchantments() {
        return this.hideEnchantments;
    }

    @Override
    public WSItemStack hideEnchantments(boolean hideEnchantments) {
        this.hideEnchantments = hideEnchantments;
        return this;
    }

    @Override
    public boolean isHidingAttributes() {
        return this.hideAttributes;
    }

    @Override
    public WSItemStack hideAttributes(boolean hideAttributes) {
        this.hideAttributes = hideAttributes;
        return this;
    }

    @Override
    public boolean isHidingUnbreakable() {
        return this.hideUnbreakable;
    }

    @Override
    public WSItemStack hideUnbreakable(boolean hideUnbreakable) {
        this.hideUnbreakable = hideUnbreakable;
        return this;
    }

    @Override
    public boolean isHidingCanDestroy() {
        return this.hideCanDestroy;
    }

    @Override
    public WSItemStack hideCanDestroy(boolean hideCanDestroy) {
        this.hideCanDestroy = hideCanDestroy;
        return this;
    }

    @Override
    public boolean isHidingCanBePlacedOn() {
        return this.hideCanBePlacedOn;
    }

    @Override
    public WSItemStack hideCanBePlacedOn(boolean hideCanBePlacedOn) {
        this.hideCanBePlacedOn = hideCanBePlacedOn;
        return this;
    }

    @Override
    public boolean isHidingPotionEffects() {
        return this.hidePotionEffects;
    }

    @Override
    public WSItemStack hidePotionEffects(boolean hidePotionEffects) {
        this.hidePotionEffects = hidePotionEffects;
        return this;
    }

    @Override
    public WSNBTTagCompound toNBTTag() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        return new SpongeNBTTagCompound(((net.minecraft.item.ItemStack)this.itemStack).func_77955_b(nbtTagCompound));
    }

    @Override
    public String toSerializedNBTTag() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        ((net.minecraft.item.ItemStack)this.itemStack).func_77955_b(nbtTagCompound);
        return nbtTagCompound.toString();
    }

    @Override
    public SpongeItemStack update() {
        try {
            Field field = ReflectionUtils.getFirstField(net.minecraft.item.ItemStack.class, Item.class);
            ReflectionUtils.setAccessible(field);
            field.set(this.itemStack, Item.func_111206_d((String)this.material.getStringId()));
            ReflectionUtils.setAccessible(field, false);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting an ItemStack id!");
            return this;
        }
        ((SpongeMaterial)this.material).writeItemStack(this.itemStack);
        if (this.displayName != null) {
            this.itemStack.offer(Keys.DISPLAY_NAME, (Object)this.displayName.getHandled());
        } else {
            this.itemStack.remove(Keys.DISPLAY_NAME);
        }
        if (!this.lore.isEmpty()) {
            this.itemStack.offer(Keys.ITEM_LORE, this.lore.stream().map(text -> ((SpongeText)text).getHandled()).collect(Collectors.toList()));
        } else {
            this.itemStack.remove(Keys.ITEM_LORE);
        }
        this.itemStack.offer(Keys.UNBREAKABLE, (Object)this.unbreakable);
        this.itemStack.offer(Keys.HIDE_ENCHANTMENTS, (Object)this.hideEnchantments);
        this.itemStack.offer(Keys.HIDE_ATTRIBUTES, (Object)this.hideAttributes);
        this.itemStack.offer(Keys.HIDE_UNBREAKABLE, (Object)this.hideUnbreakable);
        this.itemStack.offer(Keys.HIDE_CAN_DESTROY, (Object)this.hideCanDestroy);
        this.itemStack.offer(Keys.HIDE_CAN_PLACE, (Object)this.hideCanBePlacedOn);
        this.itemStack.offer(Keys.HIDE_MISCELLANEOUS, (Object)this.hidePotionEffects);
        this.itemStack.setQuantity(this.quantity);
        this.translation = new SpongeTranslation(this.itemStack.getTranslation());
        return this;
    }

    @Override
    public SpongeItemStack refresh() {
        this.displayName = this.itemStack.get(Keys.DISPLAY_NAME).map(SpongeText::of).orElse(null);
        this.lore = ((List)this.itemStack.get(Keys.ITEM_LORE).orElse(new ArrayList())).stream().map(SpongeText::of).collect(Collectors.toList());
        Optional<? extends WSMaterial> optional = WSMaterial.getById(this.itemStack.getItem().getId());
        this.material = optional.isPresent() ? optional.get() : WSBlockTypes.AIR.getDefaultState();
        ((SpongeMaterial)this.material).readContainer((ValueContainer<?>)this.itemStack);
        this.unbreakable = this.itemStack.get(Keys.UNBREAKABLE).orElse(false);
        this.hideEnchantments = this.itemStack.get(Keys.HIDE_ENCHANTMENTS).orElse(false);
        this.hideAttributes = this.itemStack.get(Keys.HIDE_ATTRIBUTES).orElse(false);
        this.hideUnbreakable = this.itemStack.get(Keys.HIDE_UNBREAKABLE).orElse(false);
        this.hideCanDestroy = this.itemStack.get(Keys.HIDE_CAN_DESTROY).orElse(false);
        this.hideCanBePlacedOn = this.itemStack.get(Keys.HIDE_CAN_PLACE).orElse(false);
        this.hidePotionEffects = this.itemStack.get(Keys.HIDE_MISCELLANEOUS).orElse(false);
        this.quantity = this.itemStack.getQuantity();
        this.translation = new SpongeTranslation(this.itemStack.getTranslation());
        return this;
    }

    @Override
    public WSTranslation getTranslation() {
        return this.translation;
    }

    @Override
    public WSItemStack clone() {
        return new SpongeItemStack(this.itemStack.copy());
    }

    @Override
    public boolean isSimilar(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeItemStack that = (SpongeItemStack)o;
        if (this.unbreakable != that.unbreakable) {
            return false;
        }
        if (this.hideEnchantments != that.hideEnchantments) {
            return false;
        }
        if (this.hideAttributes != that.hideAttributes) {
            return false;
        }
        if (this.hideUnbreakable != that.hideUnbreakable) {
            return false;
        }
        if (this.hideCanDestroy != that.hideCanDestroy) {
            return false;
        }
        if (this.hideCanBePlacedOn != that.hideCanBePlacedOn) {
            return false;
        }
        if (this.hidePotionEffects != that.hidePotionEffects) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.lore != null ? !this.lore.equals(that.lore) : that.lore != null) {
            return false;
        }
        return this.material != null ? this.material.equals(that.material) : that.material == null;
    }

    public ItemStack getHandled() {
        return this.itemStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeItemStack that = (SpongeItemStack)o;
        if (this.quantity != that.quantity) {
            return false;
        }
        if (this.unbreakable != that.unbreakable) {
            return false;
        }
        if (this.hideEnchantments != that.hideEnchantments) {
            return false;
        }
        if (this.hideAttributes != that.hideAttributes) {
            return false;
        }
        if (this.hideUnbreakable != that.hideUnbreakable) {
            return false;
        }
        if (this.hideCanDestroy != that.hideCanDestroy) {
            return false;
        }
        if (this.hideCanBePlacedOn != that.hideCanBePlacedOn) {
            return false;
        }
        if (this.hidePotionEffects != that.hidePotionEffects) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.lore != null ? !this.lore.equals(that.lore) : that.lore != null) {
            return false;
        }
        return this.material != null ? this.material.equals(that.material) : that.material == null;
    }

    public int hashCode() {
        int result = this.displayName != null ? this.displayName.hashCode() : 0;
        result = 31 * result + (this.lore != null ? this.lore.hashCode() : 0);
        result = 31 * result + (this.material != null ? this.material.hashCode() : 0);
        result = 31 * result + this.quantity;
        result = 31 * result + (this.unbreakable ? 1 : 0);
        result = 31 * result + (this.hideEnchantments ? 1 : 0);
        result = 31 * result + (this.hideAttributes ? 1 : 0);
        result = 31 * result + (this.hideUnbreakable ? 1 : 0);
        result = 31 * result + (this.hideCanDestroy ? 1 : 0);
        result = 31 * result + (this.hideCanBePlacedOn ? 1 : 0);
        result = 31 * result + (this.hidePotionEffects ? 1 : 0);
        return result;
    }
}

