/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.item;

import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.item.enchantment.Spigot13Enchantment;
import com.degoos.wetsponge.item.enchantment.WSEnchantment;
import com.degoos.wetsponge.material.Spigot13Material;
import com.degoos.wetsponge.material.WSMaterial;
import com.degoos.wetsponge.material.item.Spigot13ItemType;
import com.degoos.wetsponge.nbt.Spigot13NBTTagCompound;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.resource.spigot.Spigot13SkullBuilder;
import com.degoos.wetsponge.text.Spigot13Text;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.text.translation.Spigot13Translation;
import com.degoos.wetsponge.text.translation.WSTranslation;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13ItemStackUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Spigot13ItemStack
implements WSItemStack {
    private ItemStack itemStack;
    private WSText displayName;
    private List<WSText> lore;
    private WSMaterial material;
    private int quantity;
    private boolean unbreakable;
    private boolean hideEnchantments;
    private boolean hideAttributes;
    private boolean hideUnbreakable;
    private boolean hideCanDestroy;
    private boolean hideCanBePlacedOn;
    private boolean hidePotionEffects;
    private WSTranslation translation;

    public static Spigot13ItemStack fromFormat(String format) {
        return new Spigot13ItemStack(Spigot13SkullBuilder.createItemStackByUnknownFormat(format));
    }

    public Spigot13ItemStack(ItemStack itemStack) {
        Validate.notNull(itemStack, "ItemStack cannot be null!");
        this.itemStack = itemStack;
        this.refresh();
    }

    public Spigot13ItemStack(WSMaterial material) {
        Validate.notNull(material, "Material cannot be null!");
        this.material = material;
        this.displayName = null;
        this.lore = new ArrayList<WSText>();
        this.quantity = 1;
        WSNBTTagCompound compound = WSNBTTagCompound.of();
        compound.setInteger("Count", 1);
        compound.setString("id", material.getStringId());
        WSNBTTagCompound tag = WSNBTTagCompound.of();
        tag.setInteger("Unbreakable", 0);
        ((Spigot13Material)material).writeNBTTag(tag);
        compound.setTag("tag", tag);
        try {
            Object nmsItemStack = NMSUtils.getNMSClass("ItemStack").getMethod("a", compound.getHandled().getClass()).invoke(null, compound.getHandled());
            this.itemStack = (ItemStack)NMSUtils.getOBCClass("inventory.CraftItemStack").getMethod("asBukkitCopy", nmsItemStack.getClass()).invoke(null, nmsItemStack);
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            ((Spigot13Material)material).writeItemMeta(itemMeta);
            this.itemStack.setItemMeta(itemMeta);
            this.refresh();
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was creating an ItemStack!");
            this.itemStack = new ItemStack(Material.AIR);
        }
    }

    public Spigot13ItemStack(String nbt) throws Exception {
        this(WSNBTTagCompound.of(nbt));
    }

    public Spigot13ItemStack(WSNBTTagCompound nbt) throws Exception {
        Validate.notNull(nbt, "NBT cannot be null!");
        if (!nbt.hasKey("id")) {
            throw new NullPointerException("NBTTagCompound doesn't contain key id!");
        }
        WSMaterial.getById(nbt.getString("id")).ifPresent(material -> nbt.setString("id", material.getStringId()));
        Object nmsItemStack = NMSUtils.getNMSClass("ItemStack").getMethod("a", nbt.getHandled().getClass()).invoke(null, nbt.getHandled());
        this.itemStack = (ItemStack)NMSUtils.getOBCClass("inventory.CraftItemStack").getMethod("asBukkitCopy", nmsItemStack.getClass()).invoke(null, nmsItemStack);
        if (this.itemStack.getType() == Material.AIR) {
            InternalLogger.sendWarning("WetSponge has created a new ItemStack with id " + this.itemStack.getType().getKey() + " using the id " + nbt.getString("id"));
        }
        this.refresh();
    }

    public static WSItemStack of(WSMaterial material) {
        return new Spigot13ItemStack(material);
    }

    @Override
    public Spigot13Text getDisplayName() {
        return (Spigot13Text)this.displayName;
    }

    @Override
    public Spigot13ItemStack setDisplayName(WSText displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public List<WSText> getLore() {
        return this.lore;
    }

    @Override
    public Spigot13ItemStack setLore(List<WSText> lore) {
        this.lore = lore == null ? new ArrayList<WSText>() : new ArrayList<WSText>(lore);
        return this;
    }

    @Override
    public WSItemStack addLoreLine(WSText line) {
        this.lore.add(line == null ? WSText.empty() : line);
        return this;
    }

    @Override
    public WSItemStack clearLore() {
        this.lore.clear();
        return this;
    }

    @Override
    public Map<WSEnchantment, Integer> getEnchantments() {
        HashMap<WSEnchantment, Integer> newMap = new HashMap<WSEnchantment, Integer>();
        this.getHandled().getEnchantments().forEach((enchantment, level) -> newMap.put(new Spigot13Enchantment((Enchantment)enchantment), (Integer)level));
        return newMap;
    }

    @Override
    public Optional<Integer> getEnchantmentLevel(WSEnchantment enchantment) {
        if (!this.containsEnchantment(enchantment)) {
            return Optional.empty();
        }
        return Optional.of(this.getHandled().getEnchantmentLevel((Enchantment)enchantment.getHandled()));
    }

    @Override
    public boolean containsEnchantment(WSEnchantment enchantment) {
        return this.getHandled().containsEnchantment((Enchantment)enchantment.getHandled());
    }

    @Override
    public WSItemStack addEnchantment(WSEnchantment enchantment, int level) {
        try {
            this.getHandled().addUnsafeEnchantment((Enchantment)enchantment.getHandled(), level);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An exception has occurred while WetSponge was adding the enchantment " + enchantment.getName() + " to the item " + this.toSerializedNBTTag());
        }
        return this;
    }

    @Override
    public WSItemStack removeEnchantment(WSEnchantment enchantment) {
        try {
            this.getHandled().removeEnchantment((Enchantment)enchantment.getHandled());
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An exception has occurred while WetSponge was adding the enchantment " + enchantment.getName() + " to the item " + this.toSerializedNBTTag());
        }
        return this;
    }

    @Override
    public WSItemStack clearEnchantments() {
        this.getHandled().getEnchantments().forEach((enchantment, integer) -> this.getHandled().removeEnchantment(enchantment));
        return this;
    }

    @Override
    public WSMaterial getMaterial() {
        return this.material;
    }

    @Override
    public WSItemStack setMaterial(WSMaterial material) {
        this.material = material;
        return this;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public Spigot13ItemStack setQuantity(int quantity) {
        this.quantity = quantity;
        return this;
    }

    @Override
    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    @Override
    public WSItemStack setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    @Override
    public boolean isHidingEnchantments() {
        return this.hideEnchantments;
    }

    @Override
    public WSItemStack hideEnchantments(boolean hideEnchantments) {
        this.hideEnchantments = hideEnchantments;
        return this;
    }

    @Override
    public boolean isHidingAttributes() {
        return this.hideAttributes;
    }

    @Override
    public WSItemStack hideAttributes(boolean hideAttributes) {
        this.hideAttributes = hideAttributes;
        return this;
    }

    @Override
    public boolean isHidingUnbreakable() {
        return this.hideUnbreakable;
    }

    @Override
    public WSItemStack hideUnbreakable(boolean hideUnbreakable) {
        this.hideUnbreakable = hideUnbreakable;
        return this;
    }

    @Override
    public boolean isHidingCanDestroy() {
        return this.hideCanDestroy;
    }

    @Override
    public WSItemStack hideCanDestroy(boolean hideCanDestroy) {
        this.hideCanDestroy = hideCanDestroy;
        return this;
    }

    @Override
    public boolean isHidingCanBePlacedOn() {
        return this.hideCanBePlacedOn;
    }

    @Override
    public WSItemStack hideCanBePlacedOn(boolean hideCanBePlacedOn) {
        this.hideCanBePlacedOn = hideCanBePlacedOn;
        return this;
    }

    @Override
    public boolean isHidingPotionEffects() {
        return this.hidePotionEffects;
    }

    @Override
    public WSItemStack hidePotionEffects(boolean hidePotionEffects) {
        this.hidePotionEffects = hidePotionEffects;
        return this;
    }

    @Override
    public WSNBTTagCompound toNBTTag() {
        try {
            Object nbtTag = NMSUtils.getNMSClass("NBTTagCompound").newInstance();
            Object nmsItemStack = NMSUtils.getOBCClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class).invoke(null, this.itemStack);
            ReflectionUtils.getMethod(nmsItemStack.getClass(), "save", nbtTag.getClass()).invoke(nmsItemStack, nbtTag);
            return new Spigot13NBTTagCompound(nbtTag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return WSNBTTagCompound.of();
        }
    }

    @Override
    public String toSerializedNBTTag() {
        return this.toNBTTag().toString();
    }

    @Override
    public Spigot13ItemStack update() {
        WSNBTTagCompound compound = WSNBTTagCompound.of();
        compound.setInteger("Count", this.quantity);
        compound.setString("id", this.material.getStringId());
        WSNBTTagCompound tag = WSNBTTagCompound.of();
        ((Spigot13Material)this.material).writeNBTTag(tag);
        compound.setTag("tag", tag);
        try {
            Class<?> clazz = NMSUtils.getOBCClass("inventory.CraftItemStack");
            if (this.itemStack != null && clazz.isAssignableFrom(this.itemStack.getClass())) {
                Object handle = ReflectionUtils.setAccessible(clazz.getDeclaredField("handle")).get(this.itemStack);
                if (handle == null) {
                    return this;
                }
                Method method = handle.getClass().getMethod("load", compound.getHandled().getClass());
                method.setAccessible(true);
                method.invoke(handle, compound.getHandled());
            } else {
                Object nmsItemStack = NMSUtils.getNMSClass("ItemStack").getMethod("a", compound.getHandled().getClass()).invoke(null, compound.getHandled());
                this.itemStack = (ItemStack)NMSUtils.getOBCClass("inventory.CraftItemStack").getMethod("asBukkitCopy", nmsItemStack.getClass()).invoke(null, nmsItemStack);
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was creating an ItemStack!");
            this.itemStack = new ItemStack(Material.AIR);
        }
        if (!this.itemStack.getType().equals((Object)Material.AIR)) {
            ItemMeta meta = this.itemStack.getItemMeta();
            meta.setDisplayName(this.displayName == null ? null : this.displayName.toFormattingText());
            meta.setLore(this.lore.stream().map(WSText::toFormattingText).collect(Collectors.toList()));
            try {
                meta.setUnbreakable(this.unbreakable);
            }
            catch (Exception exception) {
            }
            meta.getItemFlags().forEach(xva$0 -> meta.removeItemFlags(new ItemFlag[]{xva$0}));
            if (this.hideEnchantments) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (this.hideAttributes) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            }
            if (this.hideUnbreakable) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            }
            if (this.hideCanDestroy) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            }
            if (this.hideCanBePlacedOn) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            }
            if (this.hidePotionEffects) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            }
            ((Spigot13Material)this.material).writeItemMeta(meta);
            this.itemStack.setItemMeta(meta);
        }
        try {
            this.translation = new Spigot13Translation(Spigot13ItemStackUtils.getDisplayName(this.itemStack));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Spigot13ItemStack refresh() {
        Optional<? extends WSMaterial> optional = WSMaterial.getById(this.itemStack.getType().getKey().toString());
        this.material = optional.isPresent() ? optional.get() : new Spigot13ItemType(-1, this.itemStack.getType().getKey().toString(), this.itemStack.getType().getKey().toString(), this.itemStack.getMaxStackSize());
        this.quantity = this.itemStack.getAmount();
        ((Spigot13Material)this.material).readNBTTag(this.toNBTTag());
        if (this.itemStack.hasItemMeta()) {
            ItemMeta meta = this.itemStack.getItemMeta();
            this.displayName = meta.hasDisplayName() ? WSText.getByFormattingText(meta.getDisplayName()) : null;
            this.lore = meta.hasLore() ? meta.getLore().stream().map(Spigot13Text::getByFormattingText).collect(Collectors.toList()) : new ArrayList<WSText>();
            try {
                this.unbreakable = meta.isUnbreakable();
            }
            catch (Exception ex) {
                this.unbreakable = false;
            }
            this.hideEnchantments = meta.hasItemFlag(ItemFlag.HIDE_ENCHANTS);
            this.hideAttributes = meta.hasItemFlag(ItemFlag.HIDE_ATTRIBUTES);
            this.hideUnbreakable = meta.hasItemFlag(ItemFlag.HIDE_UNBREAKABLE);
            this.hideCanDestroy = meta.hasItemFlag(ItemFlag.HIDE_DESTROYS);
            this.hideCanBePlacedOn = meta.hasItemFlag(ItemFlag.HIDE_PLACED_ON);
            this.hidePotionEffects = meta.hasItemFlag(ItemFlag.HIDE_POTION_EFFECTS);
            ((Spigot13Material)this.material).readItemMeta(meta);
        } else {
            this.displayName = null;
            this.lore = new ArrayList<WSText>();
            this.unbreakable = false;
            this.hideEnchantments = false;
            this.hideAttributes = false;
            this.hideUnbreakable = false;
            this.hideCanDestroy = false;
            this.hideCanBePlacedOn = false;
            this.hidePotionEffects = false;
        }
        try {
            this.translation = new Spigot13Translation(Spigot13ItemStackUtils.getDisplayName(this.itemStack));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public WSItemStack clone() {
        return new Spigot13ItemStack(this.itemStack.clone());
    }

    @Override
    public boolean isSimilar(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spigot13ItemStack that = (Spigot13ItemStack)o;
        if (this.unbreakable != that.unbreakable) {
            return false;
        }
        if (this.hideEnchantments != that.hideEnchantments) {
            return false;
        }
        if (this.hideAttributes != that.hideAttributes) {
            return false;
        }
        if (this.hideUnbreakable != that.hideUnbreakable) {
            return false;
        }
        if (this.hideCanDestroy != that.hideCanDestroy) {
            return false;
        }
        if (this.hideCanBePlacedOn != that.hideCanBePlacedOn) {
            return false;
        }
        if (this.hidePotionEffects != that.hidePotionEffects) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.lore != null ? !this.lore.equals(that.lore) : that.lore != null) {
            return false;
        }
        return this.material != null ? this.material.equals(that.material) : that.material == null;
    }

    @Override
    public WSTranslation getTranslation() {
        return this.translation;
    }

    public ItemStack getHandled() {
        return this.itemStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spigot13ItemStack that = (Spigot13ItemStack)o;
        if (this.quantity != that.quantity) {
            return false;
        }
        if (this.unbreakable != that.unbreakable) {
            return false;
        }
        if (this.hideEnchantments != that.hideEnchantments) {
            return false;
        }
        if (this.hideAttributes != that.hideAttributes) {
            return false;
        }
        if (this.hideUnbreakable != that.hideUnbreakable) {
            return false;
        }
        if (this.hideCanDestroy != that.hideCanDestroy) {
            return false;
        }
        if (this.hideCanBePlacedOn != that.hideCanBePlacedOn) {
            return false;
        }
        if (this.hidePotionEffects != that.hidePotionEffects) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.lore != null ? !this.lore.equals(that.lore) : that.lore != null) {
            return false;
        }
        return this.material != null ? this.material.equals(that.material) : that.material == null;
    }

    public int hashCode() {
        int result = this.displayName != null ? this.displayName.hashCode() : 0;
        result = 31 * result + (this.lore != null ? this.lore.hashCode() : 0);
        result = 31 * result + (this.material != null ? this.material.hashCode() : 0);
        result = 31 * result + this.quantity;
        result = 31 * result + (this.unbreakable ? 1 : 0);
        result = 31 * result + (this.hideEnchantments ? 1 : 0);
        result = 31 * result + (this.hideAttributes ? 1 : 0);
        result = 31 * result + (this.hideUnbreakable ? 1 : 0);
        result = 31 * result + (this.hideCanDestroy ? 1 : 0);
        result = 31 * result + (this.hideCanBePlacedOn ? 1 : 0);
        result = 31 * result + (this.hidePotionEffects ? 1 : 0);
        return result;
    }
}

