/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.inventory.multiinventory;

import com.degoos.wetsponge.inventory.WSInventory;
import com.degoos.wetsponge.inventory.multiinventory.GlobalMultiInventory;
import com.degoos.wetsponge.inventory.multiinventory.InventoryRows;
import com.degoos.wetsponge.inventory.multiinventory.ModifiedMultiInventory;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.text.WSText;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;

public class ModifiedGlobalMultiInventory
extends GlobalMultiInventory
implements ModifiedMultiInventory {
    private int[] slotMap;

    public ModifiedGlobalMultiInventory(WSText name, InventoryRows rows, int invAmount, String id, int[] slotMap) {
        super(name, rows, invAmount, id);
        this.slotMap = ModifiedGlobalMultiInventory.transformMap(slotMap, rows);
    }

    public ModifiedGlobalMultiInventory(WSText name, InventoryRows rows, int invAmount, String id, boolean hotBarIfUnique, int[] slotMap) {
        super(name, rows, invAmount, id, hotBarIfUnique);
        this.slotMap = ModifiedGlobalMultiInventory.transformMap(slotMap, rows);
    }

    public ModifiedGlobalMultiInventory(WSText name, int slots, InventoryRows rows, String id, int[] slotMap) {
        this(name, slots, rows, id, false, slotMap);
    }

    public ModifiedGlobalMultiInventory(WSText name, int slots, InventoryRows rows, String id, boolean hotBarIfUnique, int[] slotMap) {
        this(name, slots, rows, id, hotBarIfUnique, ModifiedGlobalMultiInventory.transformMap(slotMap, rows), true);
    }

    private ModifiedGlobalMultiInventory(WSText name, int slots, InventoryRows rows, String id, boolean hotBarIfUnique, int[] slotMap, boolean real) {
        super(name, slots, rows, id, hotBarIfUnique, slotMap.length);
        this.slotMap = slotMap;
    }

    private static int[] transformMap(int[] slotMap, InventoryRows rows) {
        HashSet<Integer> set = new HashSet<Integer>();
        int[] newSlotMap = new int[(int)Arrays.stream(slotMap).filter(slot -> slot < rows.getSlots()).count()];
        int index = 0;
        for (int i : slotMap) {
            if (i >= rows.getSlots() || set.contains(i)) continue;
            newSlotMap[index] = i;
            set.add(i);
            ++index;
        }
        return newSlotMap;
    }

    @Override
    public void setItem(int slot, WSItemStack item) {
        int inventory = Math.floorDiv(slot, this.slotMap.length);
        int invSlot = slot - inventory * this.slotMap.length;
        this.setItem(inventory, invSlot, item);
    }

    @Override
    public void setItem(int inventory, int invSlot, WSItemStack item) {
        super.setItem(inventory, this.slotMap[invSlot], item);
    }

    @Override
    public Optional<WSItemStack> getItem(int slot) {
        int inventory = Math.floorDiv(slot, this.slotMap.length);
        int invSlot = slot - inventory * this.slotMap.length;
        if (this.inventories.size() == 1) {
            return ((WSInventory)this.inventories.get(0)).getItem(this.slotMap[invSlot]);
        }
        int invNumber = Math.floorDiv(slot, this.slotMap.length);
        if (this.inventories.size() <= invNumber) {
            return Optional.empty();
        }
        return ((WSInventory)this.inventories.get(invNumber)).getItem(this.slotMap[invSlot]);
    }

    @Override
    public int size() {
        return this.getInventories().size() * this.slotMap.length;
    }

    @Override
    public Optional<Integer> getSlot(int slot) {
        int inventory = Math.floorDiv(slot, this.getRows().getSlots());
        int invSlot = slot - inventory * this.getRows().getSlots();
        for (int i = 0; i < this.slotMap.length; ++i) {
            if (this.slotMap[i] != invSlot) continue;
            return Optional.of(i + inventory * this.slotMap.length);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getRealSlot(int realSlot) {
        int inventory = Math.floorDiv(realSlot, this.slotMap.length);
        int invSlot = realSlot - inventory * this.slotMap.length;
        try {
            return Optional.of(this.slotMap[invSlot] + inventory * this.getRows().getSlots());
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }
}

