/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.inventory.multiinventory;

import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.enums.EnumTextStyle;
import com.degoos.wetsponge.inventory.WSInventory;
import com.degoos.wetsponge.inventory.multiinventory.InventoryRows;
import com.degoos.wetsponge.inventory.multiinventory.MultiInvEntry;
import com.degoos.wetsponge.inventory.multiinventory.MultiInventory;
import com.degoos.wetsponge.inventory.multiinventory.MultiInventoryClickEvent;
import com.degoos.wetsponge.inventory.multiinventory.MultiInventoryClickHotbarEvent;
import com.degoos.wetsponge.inventory.multiinventory.MultiInventoryClickPlayerInvEvent;
import com.degoos.wetsponge.inventory.multiinventory.MultiInventoryCloseEvent;
import com.degoos.wetsponge.inventory.multiinventory.MultiInventoryListener;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.HeadDatabase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GlobalMultiInventory
implements MultiInventory {
    private String id;
    private WSText name;
    private InventoryRows rows;
    protected Map<Integer, WSInventory> inventories;
    private boolean hotBar;

    public GlobalMultiInventory(WSText name, InventoryRows rows, int invAmount, String id) {
        this(name, rows, invAmount, id, false);
    }

    public GlobalMultiInventory(WSText name, InventoryRows rows, int invAmount, String id, boolean hotBarIfUnique) {
        if (invAmount < 1) {
            throw new IllegalArgumentException("invAmount can't be less than 0!");
        }
        this.name = name;
        this.id = id;
        this.rows = rows;
        this.inventories = new HashMap<Integer, WSInventory>();
        this.hotBar = hotBarIfUnique;
        for (int i = 0; i < invAmount; ++i) {
            this.inventories.put(i, this.createInv(invAmount, hotBarIfUnique));
        }
    }

    public GlobalMultiInventory(WSText name, int slots, InventoryRows rows, String id) {
        this(name, slots, rows, id, false);
    }

    public GlobalMultiInventory(WSText name, int slots, InventoryRows rows, String id, boolean hotBarIfUnique) {
        this(name, slots, rows, id, hotBarIfUnique, rows.getSlots());
    }

    public GlobalMultiInventory(WSText name, int slots, InventoryRows rows, String id, boolean hotBarIfUnique, int slotsPerInventory) {
        if (slots < 1) {
            throw new IllegalArgumentException("slots can't be less than 0!");
        }
        this.name = name;
        this.rows = rows;
        this.id = id;
        this.hotBar = hotBarIfUnique;
        this.inventories = new HashMap<Integer, WSInventory>();
        int invAmount = (int)Math.ceil((double)slots / (double)slotsPerInventory);
        for (int i = 0; i < invAmount; ++i) {
            this.inventories.put(i, this.createInv(invAmount, hotBarIfUnique));
        }
    }

    @Override
    public void setItem(int slot, WSItemStack item) {
        if (this.inventories.size() == 1) {
            this.getInventory(0).ifPresent(inventory -> inventory.setItem(item, slot));
            return;
        }
        int inventory2 = Math.floorDiv(slot, this.rows.getSlots());
        int invSlot = slot - inventory2 * this.rows.getSlots();
        this.setItem(inventory2, invSlot, item);
    }

    @Override
    public void setItem(int inventory, int invSlot, WSItemStack item) {
        if (this.inventories.size() == 1) {
            this.getInventory(0).ifPresent(inv -> inv.setItem(item, invSlot));
            return;
        }
        if (!this.inventories.containsKey(inventory) || invSlot >= this.rows.getSlots()) {
            return;
        }
        this.inventories.get(inventory).setItem(item, invSlot);
    }

    @Override
    public void setItemOnHotbar(int slot, WSItemStack itemStack) {
        if (this.inventories.size() > 1 && (slot == 2 || slot == 3 || slot == 5 || slot == 6)) {
            return;
        }
        if (this.inventories.size() == 1 && !this.hotBar) {
            return;
        }
        if (slot < 0 || slot > 8) {
            return;
        }
        int realSlot = this.rows.getSlots() + slot;
        this.inventories.values().forEach(inventory -> inventory.setItem(itemStack, realSlot));
    }

    @Override
    public Set<WSItemStack> getContents() {
        HashSet<WSItemStack> items = new HashSet<WSItemStack>();
        for (int i = 0; i < this.size(); ++i) {
            this.getItem(i).ifPresent(items::add);
        }
        return items;
    }

    @Override
    public Map<Integer, WSItemStack> getContentsMap() {
        HashMap<Integer, WSItemStack> map = new HashMap<Integer, WSItemStack>();
        for (int i = 0; i < this.size(); ++i) {
            Optional<WSItemStack> itemStack = this.getItem(i);
            if (!itemStack.isPresent()) continue;
            map.put(i, itemStack.get());
        }
        return map;
    }

    @Override
    public Map<Integer, WSInventory> getInventories() {
        return new HashMap<Integer, WSInventory>(this.inventories);
    }

    @Override
    public Optional<WSInventory> getInventory(int i) {
        return Optional.ofNullable(this.inventories.get(i));
    }

    public void open(int i, WSPlayer player) {
        if (!this.inventories.containsKey(i)) {
            return;
        }
        MultiInventoryListener.change.add(player);
        player.openInventory(this.inventories.get(i));
        MultiInventoryListener.players.put(player, new MultiInvEntry(this, i));
        MultiInventoryListener.change.remove(player);
    }

    public void openFirst(WSPlayer player) {
        this.open(0, player);
    }

    public void openLast(WSPlayer player) {
        int i = this.inventories.size() - 1;
        this.open(i, player);
    }

    public void openNext(WSPlayer player) {
        if (!MultiInventoryListener.players.containsKey(player) || !MultiInventoryListener.players.get(player).getMultiInventory().equals(this)) {
            return;
        }
        int i = MultiInventoryListener.players.get(player).getInventory();
        if (i + 1 >= this.inventories.size()) {
            return;
        }
        this.open(i + 1, player);
    }

    public void openPrevious(WSPlayer player) {
        if (!MultiInventoryListener.players.containsKey(player) || !MultiInventoryListener.players.get(player).getMultiInventory().equals(this)) {
            return;
        }
        int i = MultiInventoryListener.players.get(player).getInventory();
        if (i - 1 < 0) {
            return;
        }
        this.open(i - 1, player);
    }

    private WSInventory createInv(int invAmount, boolean hotBar) {
        WSInventory inv = WSInventory.of(invAmount > 1 || hotBar ? this.rows.getRealSlots() : this.rows.getSlots(), this.name);
        if (invAmount > 1) {
            inv.setItem(HeadDatabase.STONE_LEFT.getHead().setDisplayName(WSText.of("<", EnumTextColor.RED, WSText.of("--", EnumTextColor.RED, EnumTextStyle.STRIKETHROUGH))).update(), this.rows.getSlots() + 2);
            inv.setItem(HeadDatabase.WOOD_LEFT.getHead().setDisplayName(WSText.of("<", EnumTextColor.GREEN, WSText.of("-", EnumTextColor.GREEN, EnumTextStyle.STRIKETHROUGH))).update(), this.rows.getSlots() + 3);
            inv.setItem(HeadDatabase.WOOD_RIGHT.getHead().setDisplayName(WSText.of("-", EnumTextColor.GREEN, WSText.of(">", EnumTextColor.GREEN), EnumTextStyle.STRIKETHROUGH)).update(), this.rows.getSlots() + 5);
            inv.setItem(HeadDatabase.STONE_RIGHT.getHead().setDisplayName(WSText.of("--", EnumTextColor.RED, WSText.of(">", EnumTextColor.RED), EnumTextStyle.STRIKETHROUGH)).update(), this.rows.getSlots() + 6);
        }
        return inv;
    }

    @Override
    public InventoryRows getRows() {
        return this.rows;
    }

    @Override
    public WSText getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean hasHotBar() {
        return this.inventories.size() > 1 || this.hotBar;
    }

    @Override
    public boolean hasHotbarIfUnique() {
        return this.hotBar;
    }

    @Override
    public Optional<WSItemStack> getItem(int slot) {
        if (this.inventories.size() == 1) {
            return this.inventories.get(0).getItem(slot);
        }
        int invNumber = (int)Math.floor((double)slot / (double)this.rows.getSlots());
        if (this.inventories.size() <= invNumber) {
            return Optional.empty();
        }
        return this.inventories.get(invNumber).getItem(slot % this.rows.getSlots());
    }

    @Override
    public int size() {
        return this.inventories.size() == 1 && this.hotBar ? this.rows.getRealSlots() : this.inventories.size() * this.rows.getSlots();
    }

    @Override
    public void onClick(MultiInventoryClickEvent event) {
    }

    @Override
    public void onPlayerInventoryClick(MultiInventoryClickPlayerInvEvent event) {
    }

    @Override
    public void onHotbarClick(MultiInventoryClickHotbarEvent event) {
    }

    @Override
    public void onClose(MultiInventoryCloseEvent event) {
    }
}

