/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.inventory;

import com.degoos.wetsponge.SpongeWetSponge;
import com.degoos.wetsponge.enums.EnumInventoryRows;
import com.degoos.wetsponge.inventory.WSInventory;
import com.degoos.wetsponge.inventory.WSSlotPos;
import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.Validate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import org.spongepowered.api.block.tileentity.carrier.Dispenser;
import org.spongepowered.api.block.tileentity.carrier.Dropper;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.property.AbstractInventoryProperty;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;

public class SpongeInventory
implements WSInventory {
    private IInventory inventory;
    private Container container;
    private Inventory spongeInventory;
    private InventoryDimension dimension;
    private boolean isContainer;

    public SpongeInventory(Inventory inventory) {
        Validate.notNull(inventory, "Inventory cannot be null!");
        this.isContainer = inventory instanceof Container;
        this.inventory = this.isContainer ? null : (IInventory)inventory;
        this.container = this.isContainer ? (Container)inventory : null;
        this.spongeInventory = inventory;
        this.dimension = inventory.getProperty(InventoryDimension.class, (Object)"inventorydimension").orElse(this.getDimensionByInventoryType());
    }

    @Deprecated
    public static SpongeInventory of(int size) {
        return new SpongeInventory(Inventory.builder().property("inventorydimension", (InventoryProperty)new InventoryDimension(9, size / 9)).build((Object)SpongeWetSponge.getInstance()));
    }

    @Deprecated
    public static SpongeInventory of(int size, boolean playerInventory) {
        return new SpongeInventory(Inventory.builder().property("inventorydimension", (InventoryProperty)new InventoryDimension(size, size / 9)).build((Object)SpongeWetSponge.getInstance()));
    }

    public static SpongeInventory of(int size, WSText title, boolean playerInventory) {
        if (title == null) {
            return SpongeInventory.of(size, playerInventory);
        }
        return new SpongeInventory(Inventory.builder().property("inventorydimension", (InventoryProperty)new InventoryDimension(9, size / 9)).property("inventorytitle", (InventoryProperty)new InventoryTitle(((SpongeText)title).getHandled())).build((Object)SpongeWetSponge.getInstance()));
    }

    private InventoryDimension getDimensionByInventoryType() {
        Optional optional;
        if (this.inventory instanceof CarriedInventory && (optional = ((CarriedInventory)this.inventory).getCarrier()).isPresent() && (optional.get() instanceof Dispenser || optional.get() instanceof Dropper)) {
            return new InventoryDimension(3, 3);
        }
        return new InventoryDimension(9, 3);
    }

    @Override
    public Optional<String> getName() {
        return this.spongeInventory.getProperty(InventoryTitle.class, (Object)"inventorytitle").map(AbstractInventoryProperty::getValue).map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.LEGACY_FORMATTING_CODE).serialize(arg_0));
    }

    @Override
    public EnumInventoryRows getRows() {
        return EnumInventoryRows.getByRows(this.dimension.getRows());
    }

    @Override
    public int size() {
        return this.dimension.getRows() * this.dimension.getColumns();
    }

    @Override
    public void setItem(WSItemStack item, int slot) {
        if (this.isContainer) {
            Slot minecraftSlot = this.container.func_75139_a(slot);
            if (minecraftSlot == null) {
                return;
            }
            minecraftSlot.func_75215_d((net.minecraft.item.ItemStack)item.getHandled());
        } else {
            this.inventory.func_70299_a(slot, (net.minecraft.item.ItemStack)item.getHandled());
        }
    }

    @Override
    public void setItem(WSItemStack item, WSSlotPos slotPos) {
        this.setItem(item, slotPos.getSlot());
    }

    @Override
    public void addItem(WSItemStack item) {
        if (item == null || item.getQuantity() < 1) {
            return;
        }
        int quantity = item.getQuantity();
        Map<Integer, WSItemStack> items = this.getContentMap();
        for (WSItemStack itemStack : items.values()) {
            if (!itemStack.isSimilar(item)) continue;
            int add = itemStack.getMaterial().getMaxStackSize() - itemStack.getQuantity();
            if (add > quantity) {
                itemStack.setQuantity(itemStack.getQuantity() + quantity).update();
                quantity = 0;
                break;
            }
            itemStack.setQuantity(itemStack.getMaterial().getMaxStackSize()).update();
            quantity -= add;
        }
        if (quantity > 0) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (items.containsKey(i)) continue;
                items.put(i, item.clone().setQuantity(quantity).update());
                break;
            }
        }
        this.setContents(items);
    }

    @Override
    public Optional<WSItemStack> getItem(int slot) {
        net.minecraft.item.ItemStack itemStack;
        if (this.isContainer) {
            Slot minecraftSlot = this.container.func_75139_a(slot);
            if (minecraftSlot == null) {
                return Optional.empty();
            }
            itemStack = minecraftSlot.func_75211_c();
        } else {
            itemStack = this.inventory.func_70301_a(slot);
        }
        if (itemStack.func_190926_b()) {
            return Optional.empty();
        }
        return Optional.of(new SpongeItemStack((ItemStack)itemStack));
    }

    @Override
    public Optional<WSItemStack> getItem(WSSlotPos slotPos) {
        return this.getItem(slotPos.getSlot());
    }

    @Override
    public void removeItem(int slot) {
        if (this.isContainer) {
            Slot minecraftSlot = this.container.func_75139_a(slot);
            if (minecraftSlot == null) {
                return;
            }
            minecraftSlot.func_75215_d(net.minecraft.item.ItemStack.field_190927_a);
        } else {
            this.inventory.func_70304_b(slot);
        }
    }

    @Override
    public void removeItem(WSSlotPos slotPos) {
        this.removeItem(slotPos.getSlot());
    }

    @Override
    public List<WSItemStack> getContent() {
        ArrayList<WSItemStack> list = new ArrayList<WSItemStack>();
        for (int i = 0; i < this.size(); ++i) {
            this.getItem(i).ifPresent(list::add);
        }
        return list;
    }

    @Override
    public Map<Integer, WSItemStack> getContentMap() {
        HashMap<Integer, WSItemStack> map = new HashMap<Integer, WSItemStack>();
        for (int i = 0; i < this.size(); ++i) {
            Optional<WSItemStack> optional = this.getItem(i);
            if (!optional.isPresent()) continue;
            map.put(i, optional.get());
        }
        return map;
    }

    @Override
    public void setContents(Map<Integer, WSItemStack> contents) {
        this.inventory.func_174888_l();
        contents.forEach((integer, itemStack) -> this.setItem((WSItemStack)itemStack, (int)integer));
    }

    @Override
    public int getSize() {
        return this.dimension.getColumns() * this.dimension.getRows();
    }

    @Override
    public void clear() {
        this.inventory.func_174888_l();
    }

    public Inventory getHandled() {
        return this.spongeInventory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeInventory that = (SpongeInventory)o;
        return this.spongeInventory.equals(that.spongeInventory);
    }

    public int hashCode() {
        return this.spongeInventory.hashCode();
    }
}

