/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.inventory;

import com.degoos.wetsponge.enums.EnumInventoryRows;
import com.degoos.wetsponge.inventory.WSInventory;
import com.degoos.wetsponge.inventory.WSSlotPos;
import com.degoos.wetsponge.item.SpigotItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.Validate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SpigotInventory
implements WSInventory {
    private Inventory inventory;
    private EnumInventoryRows rows;

    public SpigotInventory(Inventory inventory) {
        Validate.notNull(inventory, "Inventory cannot be null!");
        this.inventory = inventory;
        this.rows = EnumInventoryRows.getBySize(inventory.getSize());
    }

    public static SpigotInventory of(int size) {
        return new SpigotInventory(Bukkit.createInventory(null, (int)size));
    }

    public static SpigotInventory of(int size, WSText title) {
        if (title == null) {
            return SpigotInventory.of(size);
        }
        String name = title.toFormattingText();
        return new SpigotInventory(Bukkit.createInventory(null, (int)size, (String)name.substring(0, Math.min(32, name.length()))));
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.inventory.getName());
    }

    @Override
    public EnumInventoryRows getRows() {
        return this.rows;
    }

    @Override
    public int size() {
        return this.inventory.getSize();
    }

    @Override
    public void setItem(WSItemStack item, int slot) {
        Validate.notNull(item, "Item cannot be null!");
        this.inventory.setItem(slot, ((SpigotItemStack)item).getHandled().clone());
    }

    @Override
    public void setItem(WSItemStack item, WSSlotPos slotPos) {
        Validate.notNull(slotPos, "SlotPos cannot be null!");
        this.setItem(item, slotPos.getSlot());
    }

    @Override
    public void addItem(WSItemStack item) {
        this.inventory.addItem(new ItemStack[]{((SpigotItemStack)item).getHandled()});
    }

    @Override
    public Optional<WSItemStack> getItem(int slot) {
        return Optional.ofNullable(this.inventory.getItem(slot)).map(ItemStack::clone).map(SpigotItemStack::new);
    }

    @Override
    public Optional<WSItemStack> getItem(WSSlotPos slotPos) {
        Validate.notNull(slotPos, "SlotPos cannot be null!");
        return this.getItem(slotPos.getSlot());
    }

    @Override
    public void removeItem(int slot) {
        this.inventory.setItem(slot, null);
    }

    @Override
    public void removeItem(WSSlotPos slotPos) {
        Validate.notNull(slotPos, "SlotPos cannot be null!");
        this.inventory.setItem(slotPos.getSlot(), null);
    }

    @Override
    public List<WSItemStack> getContent() {
        ItemStack[] contents = this.inventory.getContents();
        if (contents.length == 0) {
            return new ArrayList<WSItemStack>();
        }
        return Arrays.stream(contents).filter(Objects::nonNull).map(ItemStack::clone).map(SpigotItemStack::new).collect(Collectors.toList());
    }

    @Override
    public Map<Integer, WSItemStack> getContentMap() {
        HashMap<Integer, WSItemStack> map = new HashMap<Integer, WSItemStack>();
        for (int i = 0; i < this.size(); ++i) {
            Optional<WSItemStack> optional = this.getItem(i);
            if (!optional.isPresent()) continue;
            map.put(i, optional.get());
        }
        return map;
    }

    @Override
    public void setContents(Map<Integer, WSItemStack> contents) {
        this.inventory.clear();
        contents.forEach((integer, itemStack) -> this.setItem((WSItemStack)itemStack, (int)integer));
    }

    @Override
    public int getSize() {
        return this.inventory.getSize();
    }

    @Override
    public void clear() {
        this.inventory.clear();
    }

    public Inventory getHandled() {
        return this.inventory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpigotInventory that = (SpigotInventory)o;
        return this.inventory.equals(that.inventory);
    }

    public int hashCode() {
        return this.inventory.hashCode();
    }
}

