/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.hook.placeholderapi;

import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumServerType;
import com.degoos.wetsponge.hook.placeholderapi.Spigot13PlaceholderAPIExpansion;
import com.degoos.wetsponge.hook.placeholderapi.Spigot13PlaceholderAPIExpansionTranslator;
import com.degoos.wetsponge.hook.placeholderapi.Spigot13PlaceholderAPIHook;
import com.degoos.wetsponge.hook.placeholderapi.WSPlaceholderAPI;
import com.degoos.wetsponge.hook.placeholderapi.WSPlaceholderAPIExpansion;
import com.degoos.wetsponge.hook.placeholderapi.WSPlaceholderAPIHook;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class Spigot13PlaceholderAPI
extends WSPlaceholderAPI {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("[%]([^%]+)[%]");
    private static final Pattern BRACKET_PLACEHOLDER_PATTERN = Pattern.compile("[{]([^{}]+)[}]");
    private static final Pattern RELATIONAL_PLACEHOLDER_PATTERN = Pattern.compile("[%](rel_)([^%]+)[%]");

    public Spigot13PlaceholderAPI() {
        super(EnumServerType.SPIGOT, EnumServerType.PAPER_SPIGOT);
    }

    @Override
    public WSText parse(WSPlayer player, WSText text) {
        Validate.notNull(text, "Text cannot be null!");
        Validate.notNull(player, "Player cannot be null!");
        Map hooks = PlaceholderAPI.getPlaceholders();
        if (text != null && !hooks.isEmpty()) {
            Matcher m3 = PLACEHOLDER_PATTERN.matcher(text.toFormattingText());
            while (m3.find()) {
                String value;
                String format = m3.group(1);
                int index = format.indexOf("_");
                if (index <= 0 || index >= format.length()) continue;
                String pl = format.substring(0, index).toLowerCase();
                String identifier = format.substring(index + 1);
                if (!hooks.containsKey(pl) || (value = ((PlaceholderHook)hooks.get(pl)).onPlaceholderRequest((Player)player.getHandled(), identifier)) == null) continue;
                text = text.replace("%" + format + "%", Matcher.quoteReplacement(value).replace('&', '\u00a7'));
            }
            return text;
        }
        return text;
    }

    @Override
    public List<WSText> parse(WSPlayer player, List<WSText> texts) {
        Validate.notNull(texts, "Texts cannot be null!");
        return texts.stream().map(text -> this.parse(player, (WSText)text)).collect(Collectors.toList());
    }

    @Override
    public String parse(WSPlayer player, String string) {
        Validate.notNull(string, "String cannot be null!");
        return this.parse(player, WSText.of(string)).toFormattingText();
    }

    @Override
    public void registerExpansion(WSPlaceholderAPIExpansion expansion) {
        Validate.notNull(expansion, "Expansion cannot be null!");
        new Spigot13PlaceholderAPIExpansionTranslator(expansion).register();
    }

    @Override
    public void unregisterExpansion(String identifier) {
        Validate.notNull(identifier, "Identifier cannot be null!");
        PlaceholderAPI.unregisterPlaceholderHook((String)identifier);
    }

    @Override
    public Collection<WSPlaceholderAPIHook> getHooks() {
        ArrayList<WSPlaceholderAPIHook> hooks = new ArrayList<WSPlaceholderAPIHook>();
        PlaceholderAPI.getPlaceholders().forEach((s2, placeholderHook) -> {
            if (placeholderHook instanceof PlaceholderExpansion) {
                hooks.add(new Spigot13PlaceholderAPIExpansion((PlaceholderExpansion)placeholderHook));
            } else {
                hooks.add(new Spigot13PlaceholderAPIHook((PlaceholderHook)placeholderHook, (String)s2));
            }
        });
        return hooks;
    }

    @Override
    public void unregisterAllExpansions() {
        PlaceholderAPI.unregisterAllExpansions();
    }

    @Override
    public void onUnload() {
    }
}

