/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.hook;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.hook.WSHook;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class WSHookManager {
    private static WSHookManager instance = new WSHookManager();
    private Set<WSHook> hooks = new HashSet<WSHook>();
    private Map<String, Class<? extends WSHook>> hookClasses = new HashMap<String, Class<? extends WSHook>>();

    public static WSHookManager getInstance() {
        return instance;
    }

    private WSHookManager() {
        try {
            switch (WetSponge.getServerType()) {
                case PAPER_SPIGOT: 
                case SPIGOT: {
                    this.addHook("Vault", Class.forName("com.degoos.wetsponge.hook.vault.SpigotVault"));
                    this.addHook("PlaceholderAPI", Class.forName("com.degoos.wetsponge.hook.placeholderapi.SpigotPlaceholderAPI"));
                    break;
                }
            }
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An errror has occurred while WetSponge was loading a hook!");
        }
    }

    public void addHook(String plugin, Class<? extends WSHook> hook) {
        this.hookClasses.put(plugin, hook);
        if (WetSponge.getPluginManager().getBasePlugin(plugin).isPresent()) {
            this.enableHook(plugin);
        }
    }

    public Optional<Class<? extends WSHook>> getHookClass(String plugin) {
        return Optional.ofNullable(this.hookClasses.get(plugin));
    }

    private Set<WSHook> getEnabledHooks() {
        return new HashSet<WSHook>(this.hooks);
    }

    public Optional<WSHook> getHook(String plugin) {
        return this.hooks.stream().filter(hook -> hook.getPluginId().equals(plugin)).findAny();
    }

    public <T extends WSHook> Optional<T> getHook(Class<T> hookInstance) {
        return this.hooks.stream().filter(hookInstance::isInstance).map(hook -> hook).findAny();
    }

    public boolean isHookEnabled(String plugin) {
        return this.getHook(plugin).isPresent();
    }

    public <T extends WSHook> boolean isHookEnabled(Class<T> hookInstance) {
        return this.getHook(hookInstance).isPresent();
    }

    public void enableHook(String plugin) {
        if (this.getHook(plugin).isPresent()) {
            return;
        }
        this.getHookClass(plugin).ifPresent(hookClass -> {
            try {
                InternalLogger.sendInfo(WSText.of("Loading hook: ", WSText.of(plugin, EnumTextColor.YELLOW)));
                WSHook hook = (WSHook)hookClass.newInstance();
                this.hooks.add(hook);
            }
            catch (Exception ex) {
                InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was trying to load a hook!");
            }
        });
    }

    public void disableHook(String plugin) {
        this.hooks.stream().filter(hook -> hook.getPluginId().equals(plugin)).forEach(WSHook::onUnload);
        this.hooks.removeIf(hook -> hook.getPluginId().equals(plugin));
    }
}

