/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.hook;

import com.degoos.wetsponge.enums.EnumServerType;
import java.util.Arrays;
import java.util.Objects;

public abstract class WSHook {
    private String pluginId;
    private EnumServerType[] serverTypes;

    public WSHook(String pluginId, EnumServerType ... serverTypes) {
        this.pluginId = pluginId;
        this.serverTypes = serverTypes;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public EnumServerType[] getServerTypes() {
        return this.serverTypes;
    }

    public boolean isSupported(EnumServerType type) {
        for (EnumServerType target : this.serverTypes) {
            if (target != type) continue;
            return true;
        }
        return false;
    }

    public abstract void onUnload();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSHook wsHook = (WSHook)o;
        return Objects.equals(this.pluginId, wsHook.pluginId) && Arrays.equals((Object[])this.serverTypes, (Object[])wsHook.serverTypes);
    }

    public int hashCode() {
        int result = Objects.hash(this.pluginId);
        result = 31 * result + Arrays.hashCode((Object[])this.serverTypes);
        return result;
    }
}

