/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.firework;

import com.degoos.wetsponge.color.WSColor;
import com.degoos.wetsponge.enums.EnumFireworkShape;
import com.degoos.wetsponge.firework.WSFireworkEffect;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.ListUtils;
import com.degoos.wetsponge.util.Validate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.FireworkShapes;
import org.spongepowered.api.util.Color;

public class SpongeFireworkEffect
implements WSFireworkEffect {
    private FireworkEffect effect;

    public static WSFireworkEffect.Builder builder() {
        return new Builder(FireworkEffect.builder());
    }

    public SpongeFireworkEffect(FireworkEffect effect) {
        Validate.notNull(effect, "Effect cannot be null!");
        this.effect = effect;
    }

    @Override
    public boolean flickers() {
        return this.effect.flickers();
    }

    @Override
    public boolean hasTrail() {
        return this.effect.hasTrail();
    }

    @Override
    public List<WSColor> getColors() {
        return this.effect.getColors().stream().map(color -> WSColor.ofRGB(color.getRgb())).collect(Collectors.toList());
    }

    @Override
    public List<WSColor> getFadeColors() {
        return this.effect.getFadeColors().stream().map(color -> WSColor.ofRGB(color.getRgb())).collect(Collectors.toList());
    }

    @Override
    public EnumFireworkShape getShape() {
        Optional<EnumFireworkShape> optional = EnumFireworkShape.getBySpongeName(this.effect.getShape().getId());
        if (!optional.isPresent()) {
            InternalLogger.sendError("Cannot found EnumFireworkShape for " + this.effect.getShape().getId() + ". Using the default one: " + (Object)((Object)EnumFireworkShape.BALL) + ".");
            return EnumFireworkShape.BALL;
        }
        return optional.get();
    }

    @Override
    public Builder toBuilder() {
        return new Builder((FireworkEffect.Builder)FireworkEffect.builder().from((Object)this.effect));
    }

    @Override
    public WSFireworkEffect clone() {
        return this.toBuilder().build();
    }

    public FireworkEffect getHandled() {
        return this.effect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeFireworkEffect that = (SpongeFireworkEffect)o;
        return this.effect.equals(that.effect);
    }

    public int hashCode() {
        return this.effect.hashCode();
    }

    protected static class Builder
    implements WSFireworkEffect.Builder {
        private FireworkEffect.Builder builder;

        public Builder(FireworkEffect.Builder builder) {
            this.builder = builder;
        }

        @Override
        public WSFireworkEffect.Builder trail(boolean trail) {
            this.builder.trail(trail);
            return this;
        }

        @Override
        public WSFireworkEffect.Builder flicker(boolean flicker) {
            this.builder.flicker(flicker);
            return this;
        }

        @Override
        public WSFireworkEffect.Builder color(WSColor color) {
            this.builder.color(Color.ofRgb((int)color.toRGB()));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder colors(WSColor ... colors) {
            this.builder.colors(ListUtils.toArray(Color.class, Arrays.stream(colors).map(color -> Color.ofRgb((int)color.toRGB())).collect(Collectors.toList())));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder colors(Collection<WSColor> colors) {
            this.builder.colors((Iterable)colors.stream().map(color -> Color.ofRgb((int)color.toRGB())).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder fade(WSColor color) {
            this.builder.fade(Color.ofRgb((int)color.toRGB()));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder fades(WSColor ... colors) {
            this.builder.fades(ListUtils.toArray(Color.class, Arrays.stream(colors).map(color -> Color.ofRgb((int)color.toRGB())).collect(Collectors.toList())));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder fades(Collection<WSColor> colors) {
            this.builder.fades((Iterable)colors.stream().map(color -> Color.ofRgb((int)color.toRGB())).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder shape(EnumFireworkShape shape) {
            Optional optional = Sponge.getRegistry().getType(FireworkShape.class, shape.name());
            if (!optional.isPresent()) {
                InternalLogger.sendError("Cannot found FireworkShape (Sponge) for " + (Object)((Object)shape) + ". Using the default one: " + FireworkShapes.BALL.getId() + ".");
                this.builder.shape(FireworkShapes.BALL);
            } else {
                this.builder.shape((FireworkShape)optional.get());
            }
            return this;
        }

        @Override
        public WSFireworkEffect build() {
            return new SpongeFireworkEffect(this.builder.build());
        }
    }
}

