/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.event.entity;

import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.modifier.WSHealthModifier;
import com.degoos.wetsponge.enums.EnumHealingType;
import com.degoos.wetsponge.event.WSCancellable;
import com.degoos.wetsponge.event.entity.WSEntityEvent;
import com.degoos.wetsponge.util.Validate;
import java.util.HashSet;
import java.util.Set;

public class WSEntityHealEvent
extends WSEntityEvent
implements WSCancellable {
    private double baseHealth;
    private double firstFinalHealth;
    private boolean cancelled = false;
    private boolean hasFinalHeathChanged;
    private EnumHealingType healingType;
    private Set<WSHealthModifier> healthModifiers;

    public WSEntityHealEvent(WSEntity entity, double baseHealth, Set<WSHealthModifier> healthModifiers, EnumHealingType healingType, double firstFinalHealth) {
        super(entity);
        this.baseHealth = baseHealth;
        this.healthModifiers = new HashSet<WSHealthModifier>(healthModifiers);
        this.healingType = healingType;
        this.firstFinalHealth = firstFinalHealth;
        this.hasFinalHeathChanged = false;
    }

    public WSEntityHealEvent(WSEntity entity, double baseHealth, Set<WSHealthModifier> healthModifiers, EnumHealingType healingType) {
        super(entity);
        this.baseHealth = baseHealth;
        this.healthModifiers = new HashSet<WSHealthModifier>(healthModifiers);
        this.healingType = healingType;
        this.firstFinalHealth = 0.0;
        this.hasFinalHeathChanged = true;
    }

    public double getBaseHealth() {
        return this.baseHealth;
    }

    public void setBaseHealth(double baseHealth) {
        this.baseHealth = baseHealth;
        this.hasFinalHeathChanged = true;
    }

    public Set<WSHealthModifier> getHealthModifiers() {
        this.hasFinalHeathChanged = true;
        return new HashSet<WSHealthModifier>(this.healthModifiers);
    }

    public double getFinalHealth() {
        if (!this.hasFinalHeathChanged) {
            return this.firstFinalHealth;
        }
        double damage = this.baseHealth;
        for (WSHealthModifier modifier : this.healthModifiers) {
            damage = modifier.getFunction().applyAsDouble(damage);
        }
        return damage;
    }

    public void setHealthModifier(WSHealthModifier modifier) {
        Validate.notNull(modifier, "Modifier cannot be null!");
        if (this.healthModifiers.contains(modifier)) {
            this.healthModifiers.remove(modifier);
        }
        this.healthModifiers.add(modifier);
        this.hasFinalHeathChanged = true;
    }

    public EnumHealingType getHealingType() {
        return this.healingType;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

