/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.event.entity;

import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.entity.modifier.WSDamageModifier;
import com.degoos.wetsponge.enums.EnumDamageType;
import com.degoos.wetsponge.event.WSCancellable;
import com.degoos.wetsponge.event.entity.WSEntityEvent;
import com.degoos.wetsponge.util.Validate;
import java.util.HashSet;
import java.util.Set;

public class WSEntityDamageEvent
extends WSEntityEvent
implements WSCancellable {
    private double baseDamage;
    private double firstFinalDamage;
    private boolean cancelled = false;
    private boolean hasFinalDamageChanged;
    private EnumDamageType damageType;
    private Set<WSDamageModifier> damageModifiers;

    public WSEntityDamageEvent(WSEntity entity, double baseDamage, Set<WSDamageModifier> damageModifiers, EnumDamageType damageType, double firstFinalDamage) {
        super(entity);
        this.baseDamage = baseDamage;
        this.damageModifiers = new HashSet<WSDamageModifier>(damageModifiers);
        this.damageType = damageType;
        this.hasFinalDamageChanged = false;
        this.firstFinalDamage = firstFinalDamage;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(double baseDamage) {
        this.baseDamage = baseDamage;
        this.hasFinalDamageChanged = true;
    }

    public Set<WSDamageModifier> getDamageModifiers() {
        this.hasFinalDamageChanged = true;
        return new HashSet<WSDamageModifier>(this.damageModifiers);
    }

    public double getFinalDamage() {
        if (!this.hasFinalDamageChanged) {
            return this.firstFinalDamage;
        }
        double damage = this.baseDamage;
        for (WSDamageModifier modifier : this.damageModifiers) {
            damage = modifier.getFunction().applyAsDouble(damage);
        }
        return damage;
    }

    public void setDamageModifier(WSDamageModifier modifier) {
        Validate.notNull(modifier, "Modifier cannot be null!");
        if (this.damageModifiers.contains(modifier)) {
            this.damageModifiers.remove(modifier);
        }
        this.damageModifiers.add(modifier);
        this.hasFinalDamageChanged = true;
    }

    public EnumDamageType getDamageType() {
        return this.damageType;
    }

    public boolean willCauseDeath() {
        return ((WSLivingEntity)this.getEntity()).getHealth() <= this.getFinalDamage();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

