/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.enums;

import java.awt.Color;
import java.util.Arrays;
import java.util.Optional;

public enum EnumMapIllumination {
    DARKEST(3, 135),
    DARKER(0, 180),
    DARK(1, 220),
    NORMAL(2, 255);

    private byte id;
    private double multiply;

    private EnumMapIllumination(int id, int mult) {
        this.multiply = (double)mult / 255.0;
        this.id = (byte)id;
    }

    public byte getId() {
        return this.id;
    }

    public Color maskColor(Color color) {
        return new Color((int)((double)color.getRed() * this.multiply), (int)((double)color.getGreen() * this.multiply), (int)((double)color.getBlue() * this.multiply));
    }

    public static Optional<EnumMapIllumination> getById(int id) {
        return Arrays.stream(EnumMapIllumination.values()).filter(target -> target.id == id).findAny();
    }
}

