/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.enums;

import com.degoos.wetsponge.enums.EnumMapIllumination;
import com.degoos.wetsponge.map.WSMapColor;
import com.degoos.wetsponge.util.ColorUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.Optional;

public enum EnumMapBaseColor {
    AIR(0, 0),
    GRASS(1, 8368696),
    SAND(2, 16247203),
    CLOTH(3, 0xC7C7C7),
    TNT(4, 0xFF0000),
    ICE(5, 0xA0A0FF),
    IRON(6, 0xA7A7A7),
    FOLIAGE(7, 31744),
    SNOW(8, 0xFFFFFF),
    CLAY(9, 10791096),
    DIRT(10, 9923917),
    STONE(11, 0x707070),
    WATER(12, 0x4040FF),
    WOOD(13, 9402184),
    QUARTZ(14, 0xFFFCF5),
    ADOBE(15, 14188339),
    MAGENTA(16, 11685080),
    LIGHT_BLUE(17, 6724056),
    YELLOW(18, 0xE5E533),
    LIME(19, 8375321),
    PINK(20, 15892389),
    GRAY(21, 0x4C4C4C),
    SILVER(22, 0x999999),
    CYAN(23, 5013401),
    PURPLE(24, 8339378),
    BLUE(25, 3361970),
    BROWN(26, 6704179),
    GREEN(27, 6717235),
    RED(28, 0x993333),
    BLACK(29, 0x191919),
    GOLD(30, 16445005),
    DIAMOND(31, 6085589),
    LAPIS(32, 4882687),
    EMERALD(33, 55610),
    OBSIDIAN(34, 8476209),
    NETHERRACK(35, 0x700200),
    WHITE_STAINED_HARDENED_CLAY(36, 13742497),
    ORANGE_STAINED_HARDENED_CLAY(37, 10441252),
    MAGENTA_STAINED_HARDENED_CLAY(38, 9787244),
    LIGHT_BLUE_STAINED_HARDENED_CLAY(39, 7367818),
    YELLOW_STAINED_HARDENED_CLAY(40, 12223780),
    LIME_STAINED_HARDENED_CLAY(41, 6780213),
    PINK_STAINED_HARDENED_CLAY(42, 10505550),
    GRAY_STAINED_HARDENED_CLAY(43, 0x392923),
    SILVER_STAINED_HARDENED_CLAY(44, 8874850),
    CYAN_STAINED_HARDENED_CLAY(45, 0x575C5C),
    PURPLE_STAINED_HARDENED_CLAY(46, 8014168),
    BLUE_STAINED_HARDENED_CLAY(47, 4996700),
    BROWN_STAINED_HARDENED_CLAY(48, 4993571),
    GREEN_STAINED_HARDENED_CLAY(49, 5001770),
    RED_STAINED_HARDENED_CLAY(50, 9321518),
    BLACK_STAINED_HARDENED_CLAY(51, 2430480);

    private int id;
    private Color color;

    private EnumMapBaseColor(int id, int value) {
        this.id = id;
        this.color = new Color(value);
    }

    public int getId() {
        return this.id;
    }

    public Color getColor() {
        return this.color;
    }

    public static WSMapColor getBestColor(Color color) {
        if (color.getAlpha() < 65) {
            return new WSMapColor(AIR, EnumMapIllumination.NORMAL);
        }
        EnumMapBaseColor bestColor = AIR;
        EnumMapIllumination bestIllumination = EnumMapIllumination.NORMAL;
        double best = -1.0;
        for (EnumMapBaseColor target : EnumMapBaseColor.values()) {
            for (EnumMapIllumination illumination : EnumMapIllumination.values()) {
                double distance = ColorUtils.getDistance(color, illumination.maskColor(target.getColor()));
                if (!(distance < best) && best != -1.0) continue;
                best = distance;
                bestIllumination = illumination;
                bestColor = target;
            }
        }
        return new WSMapColor(bestColor, bestIllumination);
    }

    public static Optional<EnumMapBaseColor> getById(int id) {
        return Arrays.stream(EnumMapBaseColor.values()).filter(target -> target.id == id).findAny();
    }
}

