/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.projectile;

import com.degoos.wetsponge.effect.potion.SpongePotionEffect;
import com.degoos.wetsponge.effect.potion.WSPotionEffect;
import com.degoos.wetsponge.entity.projectile.SpongeArrow;
import com.degoos.wetsponge.entity.projectile.WSTippedArrow;
import com.degoos.wetsponge.enums.EnumPotionEffectType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.projectile.arrow.Arrow;
import org.spongepowered.api.entity.projectile.arrow.TippedArrow;

public class SpongeTippedArrow
extends SpongeArrow
implements WSTippedArrow {
    public SpongeTippedArrow(TippedArrow entity) {
        super((Arrow)entity);
    }

    @Override
    public void addPotionEffect(WSPotionEffect effect) {
        List list = this.getHandled().get(Keys.POTION_EFFECTS).orElse(new ArrayList());
        list.add(((SpongePotionEffect)effect).getHandled());
        this.getHandled().offer(Keys.POTION_EFFECTS, (Object)list);
    }

    @Override
    public List<WSPotionEffect> getPotionEffects() {
        return ((List)this.getHandled().get(Keys.POTION_EFFECTS).orElse(new ArrayList())).stream().map(SpongePotionEffect::new).collect(Collectors.toList());
    }

    @Override
    public void clearAllPotionEffects() {
        this.getHandled().offer(Keys.POTION_EFFECTS, new ArrayList());
    }

    @Override
    public void removePotionEffect(EnumPotionEffectType potionEffectType) {
        this.getHandled().offer(Keys.POTION_EFFECTS, ((List)this.getHandled().get(Keys.POTION_EFFECTS).orElse(new ArrayList())).stream().filter(potionEffect -> !potionEffect.getType().getName().equals(potionEffectType.name())).collect(Collectors.toList()));
    }

    public TippedArrow getHandled() {
        return (TippedArrow)super.getHandled();
    }
}

