/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.projectile;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.projectile.SpigotProjectile;
import com.degoos.wetsponge.entity.projectile.WSArrow;
import com.degoos.wetsponge.enums.EnumPickupStatus;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Projectile;

public class SpigotArrow
extends SpigotProjectile
implements WSArrow {
    public SpigotArrow(Arrow entity) {
        super((Projectile)entity);
    }

    @Override
    public double getDamage() {
        return this.getHandled().spigot().getDamage();
    }

    @Override
    public void setDamage(double damage) {
        this.getHandled().spigot().setDamage(damage);
    }

    @Override
    public int getKnockbackStrength() {
        return this.getHandled().getKnockbackStrength();
    }

    @Override
    public void setKnockbackStrength(int knockbackStrength) {
        this.getHandled().setKnockbackStrength(knockbackStrength);
    }

    @Override
    public EnumPickupStatus getPickupStatus() {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            return EnumPickupStatus.getByName(this.getHandled().getPickupStatus().name()).orElse(EnumPickupStatus.ALLOWED);
        }
        try {
            return ReflectionUtils.setAccessible(NMSUtils.getNMSClass("EntityArrow").getField("h")).getInt(this.getHandled()) == 1 ? EnumPickupStatus.ALLOWED : EnumPickupStatus.DISALLOWED;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting the PickupStatus of the arrow " + this.getHandled().getUniqueId() + "!");
            return EnumPickupStatus.ALLOWED;
        }
    }

    @Override
    public void setPickupStatus(EnumPickupStatus status) {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            this.getHandled().setPickupStatus(Arrow.PickupStatus.valueOf((String)status.name()));
        } else {
            try {
                ReflectionUtils.setAccessible(NMSUtils.getNMSClass("EntityArrow").getField("h")).setInt(this.getHandled(), status == EnumPickupStatus.ALLOWED ? 1 : 0);
            }
            catch (Exception ex) {
                InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting the PickupStatus of the arrow " + this.getHandled().getUniqueId() + "!");
            }
        }
    }

    public Arrow getHandled() {
        return (Arrow)super.getHandled();
    }
}

