/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.other;

import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.other.WSFirework;
import com.degoos.wetsponge.firework.SpongeFireworkEffect;
import com.degoos.wetsponge.firework.WSFireworkEffect;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.item.EntityFireworkRocket;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.projectile.Firework;

public class SpongeFirework
extends SpongeEntity
implements WSFirework {
    public SpongeFirework(Firework entity) {
        super((Entity)entity);
    }

    @Override
    public List<WSFireworkEffect> getFireworkEffects() {
        return ((List)this.getHandled().effects().get()).stream().map(SpongeFireworkEffect::new).collect(Collectors.toList());
    }

    @Override
    public void setFireworkEffects(Collection<WSFireworkEffect> effects) {
        this.getHandled().offer(Keys.FIREWORK_EFFECTS, effects.stream().map(effect -> ((SpongeFireworkEffect)effect).getHandled()).collect(Collectors.toList()));
    }

    @Override
    public boolean addFireworkEffect(WSFireworkEffect effect) {
        List effects = this.getHandled().get(Keys.FIREWORK_EFFECTS).orElse(new ArrayList());
        boolean added = effects.add(((SpongeFireworkEffect)effect).getHandled());
        return added && this.getHandled().offer(Keys.FIREWORK_EFFECTS, (Object)effects).isSuccessful();
    }

    @Override
    public boolean addFireworkEffects(WSFireworkEffect ... effects) {
        List list = this.getHandled().get(Keys.FIREWORK_EFFECTS).orElse(new ArrayList());
        boolean added = list.addAll(Arrays.stream(effects).map(effect -> ((SpongeFireworkEffect)effect).getHandled()).collect(Collectors.toList()));
        return added && this.getHandled().offer(Keys.FIREWORK_EFFECTS, (Object)list).isSuccessful();
    }

    @Override
    public boolean addFireworkEffects(List<WSFireworkEffect> effects) {
        List list = this.getHandled().get(Keys.FIREWORK_EFFECTS).orElse(new ArrayList());
        boolean added = list.addAll(effects.stream().map(effect -> ((SpongeFireworkEffect)effect).getHandled()).collect(Collectors.toList()));
        return added && this.getHandled().offer(Keys.FIREWORK_EFFECTS, (Object)list).isSuccessful();
    }

    @Override
    public boolean removeFireworkEffect(WSFireworkEffect effect) {
        List effects = this.getHandled().get(Keys.FIREWORK_EFFECTS).orElse(new ArrayList());
        boolean removed = effects.remove(((SpongeFireworkEffect)effect).getHandled());
        return removed && this.getHandled().offer(Keys.FIREWORK_EFFECTS, (Object)effects).isSuccessful();
    }

    @Override
    public boolean removeFireworkEffects(WSFireworkEffect ... effects) {
        List list = this.getHandled().get(Keys.FIREWORK_EFFECTS).orElse(new ArrayList());
        boolean removed = list.removeAll(Arrays.stream(effects).map(effect -> ((SpongeFireworkEffect)effect).getHandled()).collect(Collectors.toList()));
        return removed && this.getHandled().offer(Keys.FIREWORK_EFFECTS, (Object)list).isSuccessful();
    }

    @Override
    public boolean removeFireworkEffects(List<WSFireworkEffect> effects) {
        List list = this.getHandled().get(Keys.FIREWORK_EFFECTS).orElse(new ArrayList());
        boolean removed = list.removeAll(effects.stream().map(effect -> ((SpongeFireworkEffect)effect).getHandled()).collect(Collectors.toList()));
        return removed && this.getHandled().offer(Keys.FIREWORK_EFFECTS, (Object)list).isSuccessful();
    }

    @Override
    public void clearFireworkEffects() {
        this.getHandled().offer(Keys.FIREWORK_EFFECTS, new ArrayList()).isSuccessful();
    }

    @Override
    public boolean hasEffects() {
        return this.getHandled().get(Keys.FIREWORK_EFFECTS).map(List::isEmpty).orElse(true);
    }

    @Override
    public int getEffectSize() {
        return this.getHandled().get(Keys.FIREWORK_EFFECTS).map(List::size).orElse(0);
    }

    @Override
    public int getLifeTime() {
        try {
            return ReflectionUtils.setAccessible(EntityFireworkRocket.class.getDeclaredFields()[3]).getInt(this.getHandled());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public void setLifeTime(int lifeTime) {
        try {
            ReflectionUtils.setAccessible(EntityFireworkRocket.class.getDeclaredFields()[3]).setInt(this.getHandled(), lifeTime);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int getFireworkAge() {
        try {
            return ReflectionUtils.setAccessible(EntityFireworkRocket.class.getDeclaredFields()[2]).getInt(this.getHandled());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public void setFireworkAge(int fireworkAge) {
        try {
            ReflectionUtils.setAccessible(EntityFireworkRocket.class.getDeclaredFields()[2]).setInt(this.getHandled(), fireworkAge);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void detonate() {
        this.getHandled().detonate();
    }

    public Firework getHandled() {
        return (Firework)super.getHandled();
    }
}

