/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.other;

import com.degoos.wetsponge.color.WSColor;
import com.degoos.wetsponge.effect.potion.SpigotPotionEffect;
import com.degoos.wetsponge.effect.potion.WSPotionEffect;
import com.degoos.wetsponge.entity.SpigotEntity;
import com.degoos.wetsponge.entity.other.WSAreaEffectCloud;
import com.degoos.wetsponge.enums.EnumPotionEffectType;
import com.degoos.wetsponge.particle.WSParticle;
import com.degoos.wetsponge.particle.WSParticles;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.potion.PotionEffectType;

public class SpigotAreaEffectCloud
extends SpigotEntity
implements WSAreaEffectCloud {
    public SpigotAreaEffectCloud(AreaEffectCloud entity) {
        super((Entity)entity);
    }

    @Override
    public WSColor getColor() {
        return WSColor.ofRGB(this.getHandled().getColor().asRGB());
    }

    @Override
    public void setColor(WSColor color) {
        this.getHandled().setColor(Color.fromRGB((int)color.toRGB()));
    }

    @Override
    public double getRadius() {
        return this.getHandled().getRadius();
    }

    @Override
    public void setRadius(double radius) {
        this.getHandled().setRadius((float)radius);
    }

    @Override
    public WSParticle getParticle() {
        return WSParticles.getByParticleName(this.getHandled().getParticle().name()).orElse(WSParticles.SPLASH_POTION);
    }

    @Override
    public void setParticle(WSParticle particle) {
        this.getHandled().setParticle(Particle.valueOf((String)particle.getSpigotName()));
    }

    @Override
    public int getDuration() {
        return this.getHandled().getDuration();
    }

    @Override
    public void setDuration(int duration) {
        this.getHandled().setDuration(duration);
    }

    @Override
    public int getWaitTime() {
        return this.getHandled().getWaitTime();
    }

    @Override
    public void setWaitTime(int waitTime) {
        this.getHandled().setWaitTime(waitTime);
    }

    @Override
    public double getRadiusOnUse() {
        return this.getHandled().getRadiusOnUse();
    }

    @Override
    public void setRadiusOnUse(double radiusOnUse) {
        this.getHandled().setRadiusOnUse((float)radiusOnUse);
    }

    @Override
    public double getRadiusPerTick() {
        return this.getHandled().getRadiusPerTick();
    }

    @Override
    public void setRadiusPerTick(double radiusPerTick) {
        this.getHandled().setRadiusPerTick((float)radiusPerTick);
    }

    @Override
    public int getDurationOnUse() {
        return this.getHandled().getDurationOnUse();
    }

    @Override
    public void setDurationOnUse(int durationOnUse) {
        this.getHandled().setDurationOnUse(durationOnUse);
    }

    @Override
    public int getApplicationDelay() {
        return this.getHandled().getReapplicationDelay();
    }

    @Override
    public void setApplicationDelay(int applicationDelay) {
        this.getHandled().setReapplicationDelay(applicationDelay);
    }

    @Override
    public int getAge() {
        return 0;
    }

    @Override
    public void setAge(int age) {
    }

    @Override
    public void addPotionEffect(WSPotionEffect effect) {
        this.getHandled().addCustomEffect(((SpigotPotionEffect)effect).getHandled(), true);
    }

    @Override
    public List<WSPotionEffect> getPotionEffects() {
        return this.getHandled().getCustomEffects().stream().map(SpigotPotionEffect::new).collect(Collectors.toList());
    }

    @Override
    public void clearAllPotionEffects() {
        this.getHandled().clearCustomEffects();
    }

    @Override
    public void removePotionEffect(EnumPotionEffectType potionEffectType) {
        this.getHandled().removeCustomEffect(PotionEffectType.getById((int)potionEffectType.getValue()));
    }

    public AreaEffectCloud getHandled() {
        return (AreaEffectCloud)super.getHandled();
    }
}

