/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.other;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.Spigot13Entity;
import com.degoos.wetsponge.entity.other.WSFirework;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.firework.Spigot13FireworkEffect;
import com.degoos.wetsponge.firework.WSFireworkEffect;
import com.degoos.wetsponge.util.ListUtils;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class Spigot13Firework
extends Spigot13Entity
implements WSFirework {
    private static final Class<?> FIREWORK_CLASS = NMSUtils.getNMSClass("EntityFireworks");

    public Spigot13Firework(Firework entity) {
        super((Entity)entity);
    }

    @Override
    public List<WSFireworkEffect> getFireworkEffects() {
        return this.getHandled().getFireworkMeta().getEffects().stream().map(Spigot13FireworkEffect::new).collect(Collectors.toList());
    }

    @Override
    public void setFireworkEffects(Collection<WSFireworkEffect> effects) {
        FireworkMeta meta = this.getHandled().getFireworkMeta();
        meta.clearEffects();
        meta.addEffects((Iterable)effects.stream().map(effect -> ((Spigot13FireworkEffect)effect).getHandled()).collect(Collectors.toList()));
        this.getHandled().setFireworkMeta(meta);
    }

    @Override
    public boolean addFireworkEffect(WSFireworkEffect effect) {
        FireworkMeta meta = this.getHandled().getFireworkMeta();
        meta.addEffect(((Spigot13FireworkEffect)effect).getHandled());
        this.getHandled().setFireworkMeta(meta);
        return true;
    }

    @Override
    public boolean addFireworkEffects(WSFireworkEffect ... effects) {
        FireworkMeta meta = this.getHandled().getFireworkMeta();
        meta.addEffects((Iterable)Arrays.stream(effects).map(effect -> ((Spigot13FireworkEffect)effect).getHandled()).collect(Collectors.toList()));
        this.getHandled().setFireworkMeta(meta);
        return true;
    }

    @Override
    public boolean addFireworkEffects(List<WSFireworkEffect> effects) {
        FireworkMeta meta = this.getHandled().getFireworkMeta();
        meta.addEffects((Iterable)effects.stream().map(effect -> ((Spigot13FireworkEffect)effect).getHandled()).collect(Collectors.toList()));
        this.getHandled().setFireworkMeta(meta);
        return true;
    }

    @Override
    public boolean removeFireworkEffect(WSFireworkEffect effect) {
        List<WSFireworkEffect> effects = this.getFireworkEffects();
        boolean removed = effects.remove(effect);
        this.setFireworkEffects(effects);
        return removed;
    }

    @Override
    public boolean removeFireworkEffects(WSFireworkEffect ... effects) {
        List<WSFireworkEffect> list = this.getFireworkEffects();
        boolean removed = list.removeAll(ListUtils.toList(effects));
        this.setFireworkEffects(list);
        return removed;
    }

    @Override
    public boolean removeFireworkEffects(List<WSFireworkEffect> effects) {
        List<WSFireworkEffect> list = this.getFireworkEffects();
        boolean removed = list.removeAll(effects);
        this.setFireworkEffects(list);
        return removed;
    }

    @Override
    public void clearFireworkEffects() {
        FireworkMeta meta = this.getHandled().getFireworkMeta();
        meta.clearEffects();
        this.getHandled().setFireworkMeta(meta);
    }

    @Override
    public boolean hasEffects() {
        return this.getHandled().getFireworkMeta().hasEffects();
    }

    @Override
    public int getEffectSize() {
        return this.getHandled().getFireworkMeta().getEffectsSize();
    }

    @Override
    public int getLifeTime() {
        try {
            int i = WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? 3 : 1;
            return ReflectionUtils.setAccessible(FIREWORK_CLASS.getDeclaredFields()[i]).getInt(this.getNMSHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public void setLifeTime(int lifeTime) {
        try {
            int i = WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? 3 : 1;
            ReflectionUtils.setAccessible(FIREWORK_CLASS.getDeclaredFields()[i]).setInt(this.getNMSHandler(), lifeTime);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int getFireworkAge() {
        try {
            int i = WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? 2 : 0;
            return ReflectionUtils.setAccessible(FIREWORK_CLASS.getDeclaredFields()[i]).getInt(this.getNMSHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public void setFireworkAge(int fireworkAge) {
        try {
            int i = WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? 2 : 0;
            ReflectionUtils.setAccessible(FIREWORK_CLASS.getDeclaredFields()[i]).setInt(this.getNMSHandler(), fireworkAge);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void detonate() {
        this.getHandled().detonate();
    }

    public Firework getHandled() {
        return (Firework)super.getHandled();
    }

    public Object getNMSHandler() {
        return Spigot13HandledUtils.getEntityHandle((Entity)this.getHandled());
    }
}

