/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.player;

import com.degoos.wetsponge.SpongeWetSponge;
import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.living.SpongeLivingEntity;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.enums.EnumGameMode;
import com.degoos.wetsponge.inventory.SpongeInventory;
import com.degoos.wetsponge.inventory.WSInventory;
import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.WSPacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketHeldItemChange;
import com.degoos.wetsponge.particle.WSParticle;
import com.degoos.wetsponge.scoreboard.SpongeScoreboard;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.text.WSTitle;
import com.degoos.wetsponge.user.SpongeGameProfile;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.world.WSLocation;
import com.flowpowered.math.vector.Vector3f;
import java.lang.reflect.Field;
import java.net.URI;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.DisplayNameData;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.resourcepack.ResourcePacks;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.whitelist.WhitelistService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.common.text.SpongeTexts;

public class SpongePlayer
extends SpongeLivingEntity
implements WSPlayer {
    private Map<WSLocation, WSBlockType> fakeBlocks = new HashMap<WSLocation, WSBlockType>();

    public SpongePlayer(Player entity) {
        super((Living)entity);
    }

    @Override
    public String getName() {
        return this.getHandled().getName();
    }

    @Override
    public UUID getUniqueId() {
        return this.getHandled().getUniqueId();
    }

    @Override
    public WSText getDisplayedName() {
        return SpongeText.of((Text)this.getHandled().getDisplayNameData().displayName().get());
    }

    @Override
    public void setDisplayedName(WSText displayedName) {
        DisplayNameData data = this.getHandled().getDisplayNameData();
        data.set(Keys.DISPLAY_NAME, (Object)((SpongeText)displayedName).getHandled());
        this.getHandled().offer((ValueContainer)data);
    }

    @Override
    public int getFoodLevel() {
        return (Integer)this.getHandled().foodLevel().get();
    }

    @Override
    public void setFoodLevel(int foodLevel) {
        this.getHandled().offer(Keys.FOOD_LEVEL, (Object)foodLevel);
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, WSParticle particle) {
        particle.spawnParticle(location, speed, amount, this);
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Vector3f radius, WSParticle particle) {
        particle.spawnParticle(location, speed, amount, radius, this);
    }

    @Override
    public Optional<WSItemStack> getEquippedItem(EnumEquipType type) {
        Optional itemStack;
        switch (type) {
            case HELMET: {
                itemStack = this.getHandled().getHelmet();
                break;
            }
            case CHESTPLATE: {
                itemStack = this.getHandled().getChestplate();
                break;
            }
            case LEGGINGS: {
                itemStack = this.getHandled().getLeggings();
                break;
            }
            case BOOTS: {
                itemStack = this.getHandled().getBoots();
                break;
            }
            case MAIN_HAND: {
                itemStack = this.getHandled().getItemInHand(HandTypes.MAIN_HAND);
                break;
            }
            case OFF_HAND: {
                itemStack = this.getHandled().getItemInHand(HandTypes.OFF_HAND);
                break;
            }
            default: {
                itemStack = Optional.empty();
            }
        }
        return itemStack.map(SpongeItemStack::new);
    }

    @Override
    public void setEquippedItem(EnumEquipType type, WSItemStack itemStack) {
        switch (type) {
            case HELMET: {
                this.getHandled().setHelmet(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case CHESTPLATE: {
                this.getHandled().setChestplate(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case LEGGINGS: {
                this.getHandled().setLeggings(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case BOOTS: {
                this.getHandled().setBoots(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case MAIN_HAND: {
                this.getHandled().setItemInHand(HandTypes.MAIN_HAND, itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case OFF_HAND: {
                this.getHandled().setItemInHand(HandTypes.OFF_HAND, itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
            }
        }
    }

    @Override
    public WSInventory getInventory() {
        return new SpongeInventory((Inventory)this.getHandled().getInventory());
    }

    @Override
    public WSInventory getEnderChestInventory() {
        return new SpongeInventory(this.getHandled().getEnderChestInventory());
    }

    @Override
    public Optional<WSInventory> getOpenInventory() {
        return this.getHandled().getOpenInventory().map(inventory -> new SpongeInventory((Inventory)inventory));
    }

    @Override
    public void openInventory(WSInventory inventory) {
        if (inventory == null) {
            this.closeInventory();
        } else {
            this.getHandled().openInventory(((SpongeInventory)inventory).getHandled());
        }
    }

    @Override
    public void closeInventory() {
        this.getHandled().closeInventory();
    }

    @Override
    public EnumGameMode getGameMode() {
        return EnumGameMode.valueOf(((GameMode)this.getHandled().gameMode().get()).getName().toUpperCase());
    }

    @Override
    public void setGameMode(EnumGameMode gameMode) {
        this.getHandled().offer(Keys.GAME_MODE, (Object)Sponge.getRegistry().getType(GameMode.class, gameMode.name()).orElse(GameModes.SURVIVAL));
    }

    @Override
    public void kick() {
        this.getHandled().kick();
    }

    @Override
    public void kick(WSText message) {
        this.getHandled().kick(((SpongeText)message).getHandled());
    }

    @Override
    public void simulateMessage(WSText message) {
        this.getHandled().simulateChat(((SpongeText)message).getHandled(), Cause.of((EventContext)EventContext.empty(), (Object)SpongeWetSponge.getInstance()));
    }

    @Override
    public WSScoreboard getScoreboard() {
        return new SpongeScoreboard(this.getHandled().getScoreboard());
    }

    @Override
    public void setScoreboard(WSScoreboard scoreboard) {
        this.getHandled().setScoreboard(((SpongeScoreboard)scoreboard).getHandled());
    }

    @Override
    public WSGameProfile getProfile() {
        return new SpongeGameProfile(this.getHandled().getProfile());
    }

    @Override
    public void sendTitle(WSTitle title) {
        this.getHandled().sendTitle(Title.builder().title((Text)title.getTitle().map(text -> ((SpongeText)text).getHandled()).orElse(null)).subtitle((Text)title.getSubtitle().map(text -> ((SpongeText)text).getHandled()).orElse(null)).actionBar((Text)title.getActionBar().map(text -> ((SpongeText)text).getHandled()).orElse(null)).fadeIn((Integer)title.getFadeIn().orElse(null)).stay((Integer)title.getStay().orElse(null)).fadeOut((Integer)title.getFadeOut().orElse(null)).clear(title.isClear()).reset(title.isReset()).build());
    }

    @Override
    public void setResourcePack(URI uri) {
        this.getHandled().sendResourcePack(ResourcePacks.fromUriUnchecked((URI)uri));
    }

    @Override
    public String getLanguageCode() {
        return this.getHandled().getLocale().toString();
    }

    @Override
    public boolean isOnline() {
        return this.getHandled().isOnline();
    }

    @Override
    public float getExperience() {
        return (float)this.getHandled().get(Keys.EXPERIENCE_SINCE_LEVEL).orElse(0).intValue() / (float)this.getHandled().get(Keys.EXPERIENCE_FROM_START_OF_LEVEL).orElse(1).intValue();
    }

    @Override
    public void setExperience(float experience) {
        this.getHandled().offer(Keys.EXPERIENCE_SINCE_LEVEL, (Object)((int)(experience * (float)this.getHandled().get(Keys.EXPERIENCE_FROM_START_OF_LEVEL).orElse(1).intValue())));
    }

    @Override
    public int getExperienceLevel() {
        return this.getHandled().get(Keys.EXPERIENCE_LEVEL).orElse(0);
    }

    @Override
    public void setExperienceLevel(int experienceLevel) {
        this.getHandled().offer(Keys.EXPERIENCE_LEVEL, (Object)experienceLevel);
    }

    @Override
    public double getWalkingSpeed() {
        return this.getHandled().get(Keys.WALKING_SPEED).orElse(0.0);
    }

    @Override
    public void setWalkingSpeed(double walkingSpeed) {
        this.getHandled().offer(Keys.WALKING_SPEED, (Object)walkingSpeed);
    }

    @Override
    public double getFlyingSpeed() {
        return this.getHandled().get(Keys.FLYING_SPEED).orElse(0.0);
    }

    @Override
    public void setFlyingSpeed(double flyingSpeed) {
        this.getHandled().offer(Keys.FLYING_SPEED, (Object)flyingSpeed);
    }

    @Override
    public boolean canFly() {
        return this.getHandled().get(Keys.CAN_FLY).orElse(false);
    }

    @Override
    public void setCanFly(boolean canFly) {
        this.getHandled().offer(Keys.CAN_FLY, (Object)canFly);
    }

    @Override
    public boolean isFlying() {
        return this.getHandled().get(Keys.IS_FLYING).orElse(false);
    }

    @Override
    public void setFlying(boolean flying) {
        this.getHandled().offer(Keys.IS_FLYING, (Object)flying);
    }

    @Override
    public void addFakeBlock(WSLocation location, WSBlockType material) {
        this.fakeBlocks.put(location.getBlockLocation(), material);
        if (this.getWorld().equals(location.getWorld())) {
            BlockType type = Sponge.getRegistry().getType(BlockType.class, material.getStringId()).orElse(BlockTypes.AIR);
            BlockState state = type.getDefaultState();
            this.getHandled().sendBlockChange(location.toVector3i(), ((SpongeBlockType)material).writeBlockState(state));
        }
    }

    @Override
    public Optional<WSBlockType> getFakeBlock(WSLocation location) {
        return Optional.ofNullable(this.fakeBlocks.get(location.getBlockLocation()));
    }

    @Override
    public Map<WSLocation, WSBlockType> getFakeBlocks() {
        HashMap<WSLocation, WSBlockType> map = new HashMap<WSLocation, WSBlockType>();
        this.fakeBlocks.forEach((location, type) -> map.put(location.clone(), type.clone()));
        return map;
    }

    @Override
    public boolean containsFakeBlock(WSLocation location) {
        return this.fakeBlocks.containsKey(location.getBlockLocation());
    }

    @Override
    public void refreshFakeBlock(WSLocation location) {
        if (!this.getWorld().equals(location.getWorld())) {
            return;
        }
        WSLocation blockLocation = location.getBlockLocation();
        if (this.fakeBlocks.containsKey(blockLocation)) {
            this.addFakeBlock(blockLocation, this.fakeBlocks.get(blockLocation));
        }
    }

    @Override
    public void removeFakeBlock(WSLocation location) {
        WSLocation blockLocation = location.getBlockLocation();
        this.fakeBlocks.remove(blockLocation);
        if (location.getWorld().equals(this.getWorld())) {
            this.getHandled().resetBlockChange(blockLocation.toVector3i());
        }
    }

    @Override
    public void clearFakeBlocks() {
        this.fakeBlocks.keySet().stream().filter(location -> location.getWorld().equals(this.getWorld())).forEach(location -> this.getHandled().resetBlockChange(location.toVector3i()));
        this.fakeBlocks.clear();
    }

    @Override
    public void sendPacket(WSPacket packet) {
        packet.update();
        ((EntityPlayerMP)this.getHandled()).field_71135_a.func_147359_a(((SpongePacket)packet).getHandler());
    }

    @Override
    public Optional<WSItemStack> getItemOnCursor() {
        ItemStack itemStack = (ItemStack)((EntityPlayerMP)this.getHandled()).field_71071_by.func_70445_o();
        if (itemStack == null || itemStack.getItem().getId().equals(ItemTypes.AIR.getId())) {
            return Optional.empty();
        }
        return Optional.of(new SpongeItemStack(itemStack));
    }

    @Override
    public void setItemOnCursor(WSItemStack itemOnCursor) {
        if (itemOnCursor == null) {
            ((EntityPlayerMP)this.getHandled()).field_71071_by.func_70437_b(net.minecraft.item.ItemStack.field_190927_a);
        } else {
            ((EntityPlayerMP)this.getHandled()).field_71071_by.func_70437_b((net.minecraft.item.ItemStack)((SpongeItemStack)itemOnCursor).getHandled());
        }
        ((EntityPlayerMP)this.getHandled()).func_71113_k();
    }

    @Override
    public int getSelectedHotbarSlot() {
        return ((EntityPlayerMP)this.getHandled()).field_71071_by.field_70461_c;
    }

    @Override
    public void setSelectedHotbarSlot(int slot) {
        Validate.isTrue(slot >= 0 && slot < 9, "Slot is not between 0 and 8 inclusive");
        ((EntityPlayerMP)this.getHandled()).field_71071_by.field_70461_c = slot;
        this.sendPacket(WSSPacketHeldItemChange.of(slot));
    }

    @Override
    public void sendSignChange(WSLocation location, WSText[] lines) {
        Validate.notNull(location, "Location cannot be null!");
        Validate.notNull(lines, "Lines cannot be null!");
        Validate.isTrue(lines.length > 3, "Lines length must be 4!");
        EntityPlayerMP playerMP = (EntityPlayerMP)this.getHandled();
        if (playerMP.field_71135_a != null) {
            TileEntitySign signTileEntity = new TileEntitySign();
            signTileEntity.func_174878_a(new BlockPos(this.getLocation().getX(), this.getLocation().getY(), this.getLocation().getZ()));
            ITextComponent[] components = new ITextComponent[4];
            for (int i = 0; i < 4; ++i) {
                components[i] = SpongeTexts.toComponent((Text)((SpongeText)lines[i]).getHandled());
            }
            System.arraycopy(components, 0, signTileEntity.field_145915_a, 0, signTileEntity.field_145915_a.length);
            playerMP.field_71135_a.func_147359_a((Packet)signTileEntity.func_189518_D_());
        }
    }

    @Override
    public boolean hasPermission(String name) {
        return this.getHandled().hasPermission(name);
    }

    @Override
    public Set<String> getPermissions() {
        return new HashSet<String>();
    }

    @Override
    public void sendMessage(String message) {
        this.getHandled().sendMessage(TextSerializers.LEGACY_FORMATTING_CODE.deserialize(message));
    }

    @Override
    public void sendMessage(WSText text) {
        this.getHandled().sendMessage(((SpongeText)text).getHandled());
    }

    @Override
    public void sendMessages(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessages(WSText ... texts) {
        for (WSText text : texts) {
            this.sendMessage(text);
        }
    }

    @Override
    public void performCommand(String command) {
        Sponge.getGame().getCommandManager().process((CommandSource)this.getHandled(), command);
    }

    @Override
    public boolean isBanned() {
        return ((BanService)Sponge.getGame().getServiceManager().provideUnchecked(BanService.class)).isBanned(this.getHandled().getProfile());
    }

    @Override
    public boolean isWhitelisted() {
        return ((WhitelistService)Sponge.getGame().getServiceManager().provideUnchecked(WhitelistService.class)).isWhitelisted(this.getHandled().getProfile());
    }

    @Override
    public void setWhitelisted(boolean whitelisted) {
        if (whitelisted) {
            ((WhitelistService)Sponge.getGame().getServiceManager().provideUnchecked(WhitelistService.class)).addProfile(this.getHandled().getProfile());
        } else {
            ((WhitelistService)Sponge.getGame().getServiceManager().provideUnchecked(WhitelistService.class)).removeProfile(this.getHandled().getProfile());
        }
    }

    @Override
    public Optional<WSPlayer> getPlayer() {
        return Optional.of(this);
    }

    @Override
    public long getFirstPlayed() {
        Optional optional = this.getHandled().get(JoinData.class);
        return optional.map(joinData -> ((Instant)joinData.firstPlayed().get()).toEpochMilli()).orElse(0L);
    }

    @Override
    public long getLastPlayed() {
        Optional optional = this.getHandled().get(JoinData.class);
        return optional.map(joinData -> ((Instant)joinData.lastPlayed().get()).toEpochMilli()).orElse(0L);
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.getHandled().get(JoinData.class).isPresent();
    }

    public Player getHandled() {
        return (Player)super.getHandled();
    }

    public void setHandled(Object object) {
        try {
            Field field = SpongeEntity.class.getDeclaredField("entity");
            field.setAccessible(true);
            field.set(this, object);
            field.setAccessible(false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getPing() {
        return ((EntityPlayerMP)this.getHandled()).field_71138_i;
    }
}

