/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.player;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.SpigotEntity;
import com.degoos.wetsponge.entity.living.player.SpigotHuman;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.material.SpigotMaterial;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.packet.WSPacket;
import com.degoos.wetsponge.particle.WSParticle;
import com.degoos.wetsponge.resource.spigot.SpigotTitleAPI;
import com.degoos.wetsponge.scoreboard.SpigotScoreboard;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.text.SpigotText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.text.WSTitle;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import com.degoos.wetsponge.util.reflection.SpigotPacketUtils;
import com.degoos.wetsponge.world.SpigotLocation;
import com.degoos.wetsponge.world.WSLocation;
import com.flowpowered.math.vector.Vector3f;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class SpigotPlayer
extends SpigotHuman
implements WSPlayer {
    private Map<WSLocation, WSBlockType> fakeBlocks = new HashMap<WSLocation, WSBlockType>();

    public SpigotPlayer(Player entity) {
        super((HumanEntity)entity);
    }

    @Override
    public String getName() {
        return this.getHandled().getName();
    }

    @Override
    public WSText getDisplayedName() {
        return SpigotText.getByFormattingText(this.getHandled().getDisplayName());
    }

    @Override
    public void setDisplayedName(WSText displayedName) {
        this.getHandled().setDisplayName(displayedName.toFormattingText());
    }

    @Override
    public int getFoodLevel() {
        return this.getHandled().getFoodLevel();
    }

    @Override
    public void setFoodLevel(int foodLevel) {
        this.getHandled().setFoodLevel(foodLevel);
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, WSParticle particle) {
        particle.spawnParticle(location, speed, amount, this);
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Vector3f radius, WSParticle particle) {
        particle.spawnParticle(location, speed, amount, radius, this);
    }

    @Override
    public void kick() {
        this.getHandled().kickPlayer(null);
    }

    @Override
    public void kick(WSText message) {
        this.getHandled().kickPlayer(message.toFormattingText());
    }

    @Override
    public void simulateMessage(WSText message) {
        this.getHandled().chat(message.toFormattingText());
    }

    @Override
    public WSScoreboard getScoreboard() {
        return new SpigotScoreboard(this.getHandled().getScoreboard());
    }

    @Override
    public void setScoreboard(WSScoreboard scoreboard) {
        this.getHandled().setScoreboard(((SpigotScoreboard)scoreboard).getHandled());
    }

    @Override
    public WSGameProfile getProfile() {
        return WSGameProfile.of(this.getUniqueId(), this.getName());
    }

    @Override
    public void sendTitle(WSTitle wsTitle) {
        if (wsTitle.isClear() || wsTitle.isReset()) {
            SpigotTitleAPI.sendTitle(this.getHandled(), wsTitle.isReset() ? Integer.valueOf(20) : null, wsTitle.isReset() ? Integer.valueOf(60) : null, wsTitle.isReset() ? Integer.valueOf(20) : null, "", "");
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_1_11_2)) {
                SpigotTitleAPI.sendActionBarPost112(this.getHandled(), "");
            } else {
                SpigotTitleAPI.sendActionBarPre112(this.getHandled(), "");
            }
        } else {
            SpigotTitleAPI.sendTitle(this.getHandled(), wsTitle.getFadeIn().orElse(null), wsTitle.getStay().orElse(null), wsTitle.getFadeOut().orElse(null), wsTitle.getTitle().map(WSText::toFormattingText).orElse(null), wsTitle.getSubtitle().map(WSText::toFormattingText).orElse(null));
            if (wsTitle.getActionBar().isPresent()) {
                if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_1_11_2)) {
                    SpigotTitleAPI.sendActionBarPost112(this.getHandled(), wsTitle.getActionBar().map(WSText::toFormattingText).orElse(null));
                } else {
                    SpigotTitleAPI.sendActionBarPre112(this.getHandled(), wsTitle.getActionBar().map(WSText::toFormattingText).orElse(null));
                }
            }
        }
    }

    @Override
    public void setResourcePack(URI uri) {
        this.getHandled().setResourcePack(uri.toString());
    }

    @Override
    public String getLanguageCode() {
        try {
            Object playerHandled = SpigotHandledUtils.getPlayerHandle(this.getHandled());
            Field field = playerHandled.getClass().getDeclaredField("locale");
            field.setAccessible(true);
            return (String)field.get(playerHandled);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "en_US";
        }
    }

    @Override
    public boolean isOnline() {
        return this.getHandled().isOnline();
    }

    @Override
    public float getExperience() {
        return this.getHandled().getExp();
    }

    @Override
    public void setExperience(float experience) {
        this.getHandled().setExp(experience);
    }

    @Override
    public int getExperienceLevel() {
        return this.getHandled().getLevel();
    }

    @Override
    public void setExperienceLevel(int experienceLevel) {
        this.getHandled().setLevel(experienceLevel);
    }

    @Override
    public double getWalkingSpeed() {
        return this.getHandled().getWalkSpeed();
    }

    @Override
    public void setWalkingSpeed(double walkingSpeed) {
        this.getHandled().setWalkSpeed((float)walkingSpeed);
    }

    @Override
    public double getFlyingSpeed() {
        return this.getHandled().getFlySpeed();
    }

    @Override
    public void setFlyingSpeed(double flyingSpeed) {
        this.getHandled().setFlySpeed((float)flyingSpeed);
    }

    @Override
    public boolean canFly() {
        return this.getHandled().getAllowFlight();
    }

    @Override
    public void setCanFly(boolean canFly) {
        this.getHandled().setAllowFlight(canFly);
    }

    @Override
    public boolean isFlying() {
        return this.getHandled().isFlying();
    }

    @Override
    public void setFlying(boolean flying) {
        this.getHandled().setFlying(flying);
    }

    @Override
    public void addFakeBlock(WSLocation location, WSBlockType material) {
        this.fakeBlocks.put(location.getBlockLocation(), material);
        this.getHandled().sendBlockChange(((SpigotLocation)location).getLocation(), material.getNumericalId(), ((SpigotMaterial)((Object)material)).toMaterialData().getData());
    }

    @Override
    public Optional<WSBlockType> getFakeBlock(WSLocation location) {
        return Optional.ofNullable(this.fakeBlocks.get(location.getBlockLocation()));
    }

    @Override
    public Map<WSLocation, WSBlockType> getFakeBlocks() {
        HashMap<WSLocation, WSBlockType> map = new HashMap<WSLocation, WSBlockType>();
        this.fakeBlocks.forEach((location, type) -> map.put(location.clone(), type.clone()));
        return map;
    }

    @Override
    public boolean containsFakeBlock(WSLocation location) {
        return this.fakeBlocks.containsKey(location.getBlockLocation());
    }

    @Override
    public void refreshFakeBlock(WSLocation location) {
        WSLocation blockLocation = location.getBlockLocation();
        if (this.fakeBlocks.containsKey(blockLocation)) {
            this.addFakeBlock(blockLocation, this.fakeBlocks.get(blockLocation));
        }
    }

    @Override
    public void removeFakeBlock(WSLocation location) {
        WSLocation blockLocation = location.getBlockLocation();
        this.fakeBlocks.remove(blockLocation);
        WSBlockType type = location.getBlock().createState().getBlockType();
        if (location.getWorld().equals(this.getWorld())) {
            this.getHandled().sendBlockChange(((SpigotLocation)location).getLocation(), type.getNumericalId(), ((SpigotMaterial)((Object)type)).toMaterialData().getData());
        }
    }

    @Override
    public void clearFakeBlocks() {
        this.fakeBlocks.keySet().stream().filter(location -> location.getWorld().equals(this.getWorld())).forEach(this::removeFakeBlock);
        this.fakeBlocks.clear();
    }

    @Override
    public void sendPacket(WSPacket packet) {
        packet.update();
        SpigotPacketUtils.sendPacket(this.getHandled(), packet.getHandler());
    }

    @Override
    public int getSelectedHotbarSlot() {
        return this.getHandled().getInventory().getHeldItemSlot();
    }

    @Override
    public void setSelectedHotbarSlot(int slot) {
        this.getHandled().getInventory().setHeldItemSlot(slot);
    }

    @Override
    public void sendSignChange(WSLocation location, WSText[] lines) {
        String[] newLines = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            newLines[i] = lines[i].toFormattingText();
        }
        this.getHandled().sendSignChange(((SpigotLocation)location).getLocation(), newLines);
    }

    @Override
    public void sendMessage(String message) {
        this.getHandled().sendMessage(message);
    }

    @Override
    public void sendMessage(WSText text) {
        this.getHandled().spigot().sendMessage(((SpigotText)text).getHandled());
    }

    @Override
    public void sendMessages(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessages(WSText ... texts) {
        for (WSText text : texts) {
            this.sendMessage(text);
        }
    }

    @Override
    public void performCommand(String command) {
        Bukkit.dispatchCommand((CommandSender)this.getHandled(), (String)command);
    }

    @Override
    public boolean isBanned() {
        return this.getHandled().isBanned();
    }

    @Override
    public boolean isWhitelisted() {
        return this.getHandled().isWhitelisted();
    }

    @Override
    public void setWhitelisted(boolean whitelisted) {
        this.getHandled().setWhitelisted(true);
    }

    @Override
    public Optional<WSPlayer> getPlayer() {
        return Optional.of(this);
    }

    @Override
    public long getFirstPlayed() {
        return this.getHandled().getFirstPlayed();
    }

    @Override
    public long getLastPlayed() {
        return this.getHandled().getLastPlayed();
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.getHandled().hasPlayedBefore();
    }

    public Player getHandled() {
        return (Player)super.getHandled();
    }

    public void setHandled(Object object) {
        try {
            Field field = SpigotEntity.class.getDeclaredField("entity");
            field.setAccessible(true);
            field.set(this, object);
            field.setAccessible(false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getPing() {
        try {
            Object player = SpigotHandledUtils.getPlayerHandle(this.getHandled());
            Field ping = player.getClass().getDeclaredField("ping");
            ping.setAccessible(true);
            return ping.getInt(player);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

