/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.monster;

import com.degoos.wetsponge.entity.living.monster.SpongeMonster;
import com.degoos.wetsponge.entity.living.monster.WSSkeleton;
import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import java.util.Optional;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.monster.Monster;
import org.spongepowered.api.entity.living.monster.Skeleton;

public class SpongeSkeleton
extends SpongeMonster
implements WSSkeleton {
    public SpongeSkeleton(Skeleton entity) {
        super((Monster)entity);
    }

    @Override
    public Optional<WSItemStack> getEquippedItem(EnumEquipType type) {
        Optional itemStack;
        switch (type) {
            case HELMET: {
                itemStack = this.getHandled().getHelmet();
                break;
            }
            case CHESTPLATE: {
                itemStack = this.getHandled().getChestplate();
                break;
            }
            case LEGGINGS: {
                itemStack = this.getHandled().getLeggings();
                break;
            }
            case BOOTS: {
                itemStack = this.getHandled().getBoots();
                break;
            }
            case MAIN_HAND: {
                itemStack = this.getHandled().getItemInHand(HandTypes.MAIN_HAND);
                break;
            }
            case OFF_HAND: {
                itemStack = this.getHandled().getItemInHand(HandTypes.OFF_HAND);
                break;
            }
            default: {
                itemStack = Optional.empty();
            }
        }
        return itemStack.map(SpongeItemStack::new);
    }

    @Override
    public void setEquippedItem(EnumEquipType type, WSItemStack itemStack) {
        switch (type) {
            case HELMET: {
                this.getHandled().setHelmet(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case CHESTPLATE: {
                this.getHandled().setChestplate(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case LEGGINGS: {
                this.getHandled().setLeggings(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case BOOTS: {
                this.getHandled().setBoots(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case MAIN_HAND: {
                this.getHandled().setItemInHand(HandTypes.MAIN_HAND, itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case OFF_HAND: {
                this.getHandled().setItemInHand(HandTypes.OFF_HAND, itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
            }
        }
    }

    public Skeleton getHandled() {
        return (Skeleton)super.getHandled();
    }
}

