/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.monster;

import com.degoos.wetsponge.entity.living.monster.SpongeMonster;
import com.degoos.wetsponge.entity.living.monster.WSCreeper;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.monster.Creeper;
import org.spongepowered.api.entity.living.monster.Monster;

public class SpongeCreeper
extends SpongeMonster
implements WSCreeper {
    public SpongeCreeper(Creeper entity) {
        super((Monster)entity);
    }

    @Override
    public boolean isPowered() {
        return this.getHandled().get(Keys.CREEPER_CHARGED).orElse(false);
    }

    @Override
    public void setPowered(boolean powered) {
        this.getHandled().offer(Keys.CREEPER_CHARGED, (Object)powered);
    }

    @Override
    public int getFuseDuration() {
        return (Integer)this.getHandled().getFuseData().fuseDuration().get();
    }

    @Override
    public void setFuseDuration(int fuseDuration) {
        this.getHandled().offer(Keys.FUSE_DURATION, (Object)fuseDuration);
    }

    @Override
    public int getTicksRemaining() {
        return (Integer)this.getHandled().getFuseData().ticksRemaining().get();
    }

    @Override
    public void setTicksRemaining(int ticksRemaining) {
        this.getHandled().offer(Keys.TICKS_REMAINING, (Object)ticksRemaining);
    }

    @Override
    public boolean isPrimed() {
        return this.getHandled().isPrimed();
    }

    @Override
    public void prime() {
        this.getHandled().prime();
    }

    @Override
    public void defuse() {
        this.getHandled().defuse();
    }

    @Override
    public int setExplosionRadius() {
        return ((Optional)this.getHandled().explosionRadius().get()).orElse(2);
    }

    @Override
    public void setExplosionRadius(int explosionRadius) {
        this.getHandled().offer(Keys.EXPLOSION_RADIUS, Optional.of(explosionRadius));
    }

    @Override
    public void detonate() {
        this.getHandled().detonate();
    }

    public Creeper getHandled() {
        return (Creeper)super.getHandled();
    }
}

